/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.tokenauth.spring;

import java.util.Collection;
import org.genesys.blocks.oauth.model.OAuthClient;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.model.BasicUser;
import org.genesys.blocks.tokenauth.model.ApiToken;
import org.genesys.blocks.tokenauth.spring.ApiTokenAuthenticationToken;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public interface ApiTokenDetailsService
extends AuthenticationUserDetailsService<ApiTokenAuthenticationToken> {
    public ApiTokenDetails<? extends AclSid> loadUserDetails(ApiTokenAuthenticationToken var1) throws UsernameNotFoundException;

    public static abstract class ApiTokenDetails<T extends AclSid>
    implements UserDetails,
    CredentialsContainer {
        protected T sid;
        private ApiToken token;

        public ApiTokenDetails(T sid, ApiToken token) {
            this.sid = sid;
            this.token = token;
        }

        public final String getPassword() {
            return this.token.getToken();
        }

        public final String getUsername() {
            return ((AclSid)((Object)this.sid)).getSid();
        }

        public boolean isAccountNonExpired() {
            return this.sid.isActive();
        }

        public boolean isAccountNonLocked() {
            return this.sid.isActive();
        }

        public final boolean isCredentialsNonExpired() {
            return this.token.isCredentialsNonExpired();
        }

        public final boolean isEnabled() {
            return this.sid.isActive() && this.token.isActive();
        }

        public void eraseCredentials() {
            this.token = null;
        }
    }

    public static final class ApiTokenUserDetails
    extends ApiTokenDetails<BasicUser<?>> {
        public ApiTokenUserDetails(BasicUser<?> sid, ApiToken token) {
            super(sid, token);
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return ((BasicUser)this.sid).getAuthorities();
        }

        @Override
        public boolean isAccountNonExpired() {
            return ((BasicUser)this.sid).isAccountNonExpired();
        }

        @Override
        public boolean isAccountNonLocked() {
            return ((BasicUser)this.sid).isAccountNonLocked();
        }
    }

    public static final class ApiTokenClientDetails
    extends ApiTokenDetails<OAuthClient> {
        public ApiTokenClientDetails(OAuthClient sid, ApiToken token) {
            super(sid, token);
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return ((OAuthClient)this.sid).getAuthorities();
        }
    }
}

