/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.tokenauth.spring;

import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.tokenauth.spring.ApiTokenAuthenticationToken;
import org.genesys.blocks.tokenauth.spring.ApiTokenDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.util.Assert;

public class ApiTokenAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ApiTokenAuthenticationProvider.class);
    private int order = -1;
    private ApiTokenDetailsService apiTokenDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.apiTokenDetailsService, (String)"An ApiTokenDetailsService must be set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        log.debug("API-Token authentication: {}", (Object)authentication);
        if (authentication.getCredentials() == null) {
            log.debug("No API-Token credentials found in request.");
            throw new BadCredentialsException("No token found in request.");
        }
        ApiTokenDetailsService.ApiTokenDetails<? extends AclSid> userDetails = this.apiTokenDetailsService.loadUserDetails((ApiTokenAuthenticationToken)authentication);
        this.userDetailsChecker.check(userDetails);
        ApiTokenAuthenticationToken result = new ApiTokenAuthenticationToken(userDetails.sid, authentication.getCredentials(), userDetails.getAuthorities());
        result.setDetails(userDetails);
        return result;
    }

    public final boolean supports(Class<?> authentication) {
        return ApiTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int i) {
        this.order = i;
    }

    public ApiTokenDetailsService getApiTokenDetailsService() {
        return this.apiTokenDetailsService;
    }

    public UserDetailsChecker getUserDetailsChecker() {
        return this.userDetailsChecker;
    }

    public void setApiTokenDetailsService(ApiTokenDetailsService apiTokenDetailsService) {
        this.apiTokenDetailsService = apiTokenDetailsService;
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = userDetailsChecker;
    }
}

