/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.hibernate.annotations.DiscriminatorOptions;

@Entity
@Table(name="acl_sid", uniqueConstraints={@UniqueConstraint(columnNames={"sid"})})
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.INTEGER)
@DiscriminatorValue(value="0")
@DiscriminatorOptions(force=false)
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="sid")
@Cacheable
public class AclSid
extends AuditedVersionedModel {
    private static final long serialVersionUID = -8665345718313672678L;
    public static final String OIDC_SID_ID = "sidId";
    @Column(name="principal", nullable=false, length=1)
    private boolean principal;
    @Column(name="sid", nullable=false, unique=true, length=100)
    private String sid;
    @JsonIgnore
    @OneToMany(mappedBy="ownerSid", fetch=FetchType.LAZY, cascade={})
    private List<AclObjectIdentity> objectIdentities;
    @JsonIgnore
    @OneToMany(mappedBy="aclSid", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<AclEntry> aclEntries;

    public String getFullName() {
        return this.sid;
    }

    public boolean canEqual(Object other) {
        return other instanceof AclSid;
    }

    @Override
    public String toString() {
        return this.sid;
    }

    public boolean isPrincipal() {
        return this.principal;
    }

    public String getSid() {
        return this.sid;
    }

    public List<AclObjectIdentity> getObjectIdentities() {
        return this.objectIdentities;
    }

    public List<AclEntry> getAclEntries() {
        return this.aclEntries;
    }

    public void setPrincipal(boolean principal) {
        this.principal = principal;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    @JsonIgnore
    public void setObjectIdentities(List<AclObjectIdentity> objectIdentities) {
        this.objectIdentities = objectIdentities;
    }

    @JsonIgnore
    public void setAclEntries(List<AclEntry> aclEntries) {
        this.aclEntries = aclEntries;
    }
}

