/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.oauth.service.OAuthClientService;
import org.genesys.blocks.tokenauth.model.ApiToken;
import org.genesys.blocks.tokenauth.service.ApiTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.web.filter.OncePerRequestFilter;

public class InvalidatedTokenFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(InvalidatedTokenFilter.class);
    private final OAuth2AuthorizationService authorizationService;
    private final ApiTokenService apiTokenService;
    private final OAuthClientService oAuthClientService;

    public InvalidatedTokenFilter(OAuth2AuthorizationService authorizationService, ApiTokenService apiTokenService, OAuthClientService oAuthClientService) {
        this.authorizationService = authorizationService;
        this.apiTokenService = apiTokenService;
        this.oAuthClientService = oAuthClientService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String authorizationHeader = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            if (authorizationHeader.startsWith("Bearer ")) {
                String accessToken = authorizationHeader.substring(7);
                OAuth2Authorization authorization = this.authorizationService.findByToken(accessToken, OAuth2TokenType.ACCESS_TOKEN);
                if (authorization == null) throw new AuthenticationCredentialsNotFoundException("Access token is invalidated");
                OAuth2Authorization.Token authorizedToken = authorization.getAccessToken();
                if (authorizedToken != null && !authorizedToken.isActive()) {
                    log.debug("Access token is invalidated for authorization id = {}", (Object)authorization.getId());
                    throw new AuthenticationCredentialsNotFoundException("Access token is invalidated");
                }
                if (!this.oAuthClientService.isClientActive(authorization.getRegisteredClientId())) {
                    log.debug("Client {} is not active", (Object)authorization.getRegisteredClientId());
                    throw new AuthenticationCredentialsNotFoundException("Client is not active");
                }
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)authorizationHeader, (CharSequence)"API-Token")) {
                String token = authorizationHeader.substring(10);
                if (this.apiTokenService == null) {
                    log.warn("Cannot check API-Token validity without ApiTokenService");
                    throw new AuthenticationCredentialsNotFoundException("API-Token authentication not supported");
                }
                ApiToken apiToken = this.apiTokenService.getToken(this.apiTokenService.encodeToken(token));
                if (apiToken == null) {
                    throw new AuthenticationCredentialsNotFoundException("Invalid API token");
                }
                if (!apiToken.isCredentialsNonExpired()) {
                    throw new AuthenticationCredentialsNotFoundException("API token expired");
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

