/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.component;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.AuditableAccessControlEntry;

public class Slf4jLogAuditLogger
implements AuditLogger {
    private static final Logger log = LoggerFactory.getLogger(Slf4jLogAuditLogger.class);

    public void logIfNeeded(boolean granted, AccessControlEntry ace) {
        if (ace instanceof AuditableAccessControlEntry) {
            AuditableAccessControlEntry auditableAce = (AuditableAccessControlEntry)ace;
            if (granted && auditableAce.isAuditSuccess()) {
                log.debug("GRANTED due to ACE: " + ace);
            } else if (!granted && auditableAce.isAuditFailure()) {
                log.debug("DENIED due to ACE: " + ace);
            }
        }
    }
}

