/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.component;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.genesys.blocks.oauth.model.OAuthClient;
import org.genesys.blocks.oauth.service.OAuthClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuthClientOriginCheckFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(OAuthClientOriginCheckFilter.class);
    @Autowired
    private OAuthClientService clientDetailsService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AbstractOAuth2TokenAuthenticationToken) {
            AbstractOAuth2TokenAuthenticationToken oauthAuth = (AbstractOAuth2TokenAuthenticationToken)authentication;
            if (!this.checkValidOrigin(request, oauthAuth)) {
                response.sendError(403, "Request origin not valid");
                return;
            }
        } else {
            log.debug("Authentication null for origin: {}", (Object)request.getHeader("Origin"));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean checkValidOrigin(HttpServletRequest request, AbstractOAuth2TokenAuthenticationToken<?> authAuth) {
        Jwt token = (Jwt)authAuth.getToken();
        if (log.isTraceEnabled()) {
            log.trace(request.getRequestURI());
            for (String headerName : Collections.list(request.getHeaderNames())) {
                log.trace(">> {}: {}", (Object)headerName, (Object)request.getHeader(headerName));
            }
        }
        String reqOrigin = request.getHeader("Origin");
        String reqReferrer = request.getHeader("Referer");
        if (token != null) {
            boolean isGet = "get".equalsIgnoreCase(request.getMethod());
            List claimAud = (List)token.getClaim("aud");
            String clientId = (String)claimAud.get(0);
            try {
                Set<String> allowedOrigins = this.getAllowedOrigins(clientId);
                if (!allowedOrigins.isEmpty()) {
                    if (reqOrigin == null && reqReferrer == null) {
                        log.info("No origin/referrer header in request. Denying.");
                        return false;
                    }
                    for (String allowedOrigin : allowedOrigins) {
                        if (reqOrigin != null && reqOrigin.startsWith(allowedOrigin)) {
                            log.debug("Origin match: {} for {}", (Object)reqOrigin, (Object)allowedOrigin);
                            return true;
                        }
                        if (!isGet && reqOrigin != null || reqReferrer == null || !reqReferrer.startsWith(allowedOrigin)) continue;
                        log.debug("Referrer match: {} for {}", (Object)reqReferrer, (Object)allowedOrigin);
                        return true;
                    }
                    log.info("No origin/referrer match: {} or {} in {}", new Object[]{reqOrigin, reqReferrer, allowedOrigins});
                    return false;
                }
                if (reqOrigin != null || reqReferrer != null) {
                    log.info("{} may not be used from browsers. Denying.", (Object)clientId);
                    return false;
                }
                return true;
            }
            catch (Throwable e) {
                log.warn("Error loading client origins: {}", (Object)e.getMessage());
            }
        }
        log.debug("Allowing request with Origin: {}", (Object)reqOrigin);
        return true;
    }

    private Set<String> getAllowedOrigins(String clientId) {
        OAuthClient clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        if (clientDetails == null) {
            throw new NullPointerException("No such client");
        }
        return clientDetails.getAllowedOrigins();
    }
}

