/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.blocks.security.component;

import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.AuditableAccessControlEntry;

import lombok.extern.slf4j.Slf4j;

/**
 * The Class Slf4jLogAuditLogger.
 */
@Slf4j
public class Slf4jLogAuditLogger implements AuditLogger {

	/*
	 * (non-Javadoc)
	 * @see
	 * org.springframework.security.acls.domain.AuditLogger#logIfNeeded(boolean,
	 * org.springframework.security.acls.model.AccessControlEntry)
	 */
	@Override
	public void logIfNeeded(final boolean granted, final AccessControlEntry ace) {
		if (ace instanceof AuditableAccessControlEntry) {
			final AuditableAccessControlEntry auditableAce = (AuditableAccessControlEntry) ace;

			if (granted && auditableAce.isAuditSuccess()) {
				log.debug("GRANTED due to ACE: " + ace);
			} else if (!granted && auditableAce.isAuditFailure()) {
				log.debug("DENIED due to ACE: " + ace);
			}
		}
	}
}
