/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.blocks.security;

/**
 * The Class NotUniqueUserException.
 */
public class NotUniqueUserException extends UserException {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -3260458819774485495L;

	/**
	 * Instantiates a new not unique user exception.
	 */
	public NotUniqueUserException() {
	}

	/**
	 * Instantiates a new not unique user exception.
	 *
	 * @param message the message
	 */
	public NotUniqueUserException(final String message) {
		super(message);
	}

	/**
	 * Instantiates a new not unique user exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public NotUniqueUserException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * Instantiates a new not unique user exception.
	 *
	 * @param cause the cause
	 */
	public NotUniqueUserException(final Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new not unique user exception.
	 *
	 * @param cause the cause
	 * @param email the email
	 */
	public NotUniqueUserException(final Throwable cause, final String email) {
		super(cause);
		this.email = email;
	}

	/** The email. */
	private String email;

	/**
	 * Gets the email.
	 *
	 * @return the email
	 */
	public String getEmail() {
		return email;
	}
}
