/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.security.NoUserFoundException;
import org.genesys.blocks.security.NotUniqueUserException;
import org.genesys.blocks.security.UserException;
import org.genesys.blocks.security.model.BasicUser;
import org.genesys.blocks.security.persistence.AclEntryPersistence;
import org.genesys.blocks.security.service.BasicUserService;
import org.genesys.blocks.security.service.PasswordPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class BasicUserServiceImpl<R extends GrantedAuthority, T extends BasicUser<R>>
implements BasicUserService<R, T>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(BasicUserServiceImpl.class);
    private static final String THIS_IS_NOT_A_PASSWORD = "THIS-IS-NOT-A-PASSWORD";
    private long accountLockoutTime = 300000L;
    private JpaRepository<T, Long> _repository;
    @Autowired
    @Lazy
    protected PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    @Lazy
    private PasswordPolicy passwordPolicy;
    @Autowired(required=false)
    @Lazy
    protected AclEntryPersistence aclEntryRepository;

    @Transactional
    public void afterPropertiesSet() throws Exception {
        this._repository = this.getUserRepository();
        try {
            this.loadUserByUsername("SYSTEM_ADMIN");
        }
        catch (UsernameNotFoundException e) {
            T systemAdmin = this.createSystemAdministrator("SYSTEM_ADMIN");
            if (systemAdmin == null) {
                throw new UserException("Implementation did not return a valid SYSTEM_ADMIN account");
            }
            if (((BasicUser)((Object)systemAdmin)).getAccountType() != BasicUser.AccountType.SYSTEM) {
                throw new UserException("Implementation did not return a SYSTEM_ADMIN account of type SYSTEM");
            }
            log.warn("New system admin {} account created with uuid={}", (Object)"SYSTEM_ADMIN", (Object)((BasicUser)((Object)systemAdmin)).getUuid());
        }
    }

    protected abstract JpaRepository<T, Long> getUserRepository();

    protected abstract T createSystemAdministrator(String var1) throws UserException;

    public void setAccountLockoutTime(long accountLockoutTime) {
        this.accountLockoutTime = accountLockoutTime;
    }

    @Override
    public abstract List<R> getDefaultUserRoles();

    @Override
    public abstract List<R> listAvailableRoles();

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Object user = this.getUserByEmail(username);
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        LinkedHashSet<Object> runtimeAuthorities = new LinkedHashSet<Object>(20);
        Set<GrantedAuthority> dynamicAuthorities = this.getDynamicAuthorities(user);
        if (CollectionUtils.isNotEmpty(dynamicAuthorities)) {
            runtimeAuthorities.addAll(dynamicAuthorities);
        }
        runtimeAuthorities.addAll(((BasicUser)((Object)user)).getRoles());
        Collection defaultRoles = this.getDefaultUserRoles();
        if (CollectionUtils.isNotEmpty((Collection)defaultRoles)) {
            runtimeAuthorities.removeAll(defaultRoles);
            runtimeAuthorities.addAll(defaultRoles);
        }
        ((BasicUser)((Object)user)).setRuntimeAuthorities(new ArrayList<GrantedAuthority>(runtimeAuthorities));
        return user;
    }

    protected abstract Set<GrantedAuthority> getDynamicAuthorities(T var1);

    @Override
    public T getUser(long id) {
        BasicUser user = this._repository.findById((Object)id).orElse(null);
        return (T)((Object)this.deepLoad(user));
    }

    public T deepLoad(T user) {
        if (user != null) {
            ((BasicUser)((Object)user)).getRoles().size();
        }
        return user;
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') || principal.id == #user.id")
    public T updateUser(T user, String email, String fullName) throws NotUniqueUserException, UserException {
        if (!StringUtils.equals((CharSequence)email, (CharSequence)((BasicUser)((Object)(user = (BasicUser)((Object)this._repository.findById((Object)user.getId()).orElseThrow(() -> new EntityNotFoundException("Record not found.")))))).getEmail()) && this.getUserByEmail(email) != null) {
            throw new NotUniqueUserException("Email address already registered");
        }
        ((BasicUser)((Object)user)).setEmail(email);
        ((BasicUser)((Object)user)).setFullName(fullName);
        return (T)((Object)this.deepLoad((BasicUser)((Object)this._repository.save(user))));
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public void deleteUser(T user) {
        this._repository.delete(user);
    }

    @Override
    @Transactional
    public T setRoles(T user, Set<R> newRoles) {
        user = (BasicUser)((Object)this._repository.findById((Object)user.getId()).orElseThrow(() -> new EntityNotFoundException("Record not found.")));
        HashSet<R> roles = new HashSet<R>(newRoles);
        roles.removeAll(this.getDefaultUserRoles());
        if (roles.containsAll(((BasicUser)((Object)user)).getRoles()) && ((BasicUser)((Object)user)).getRoles().containsAll(roles)) {
            log.debug("Roles {} match {}. No change.", newRoles, ((BasicUser)((Object)user)).getRoles());
            return (T)user;
        }
        ((BasicUser)((Object)user)).getRoles().clear();
        ((BasicUser)((Object)user)).getRoles().addAll(roles);
        log.info("Setting roles for user {} to {}", (Object)((BasicUser)((Object)user)).getEmail(), ((BasicUser)((Object)user)).getRoles());
        return (T)((Object)this.deepLoad((BasicUser)((Object)this._repository.save(user))));
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') || principal.id == #user.id")
    public T changePassword(T user, String password) throws PasswordPolicy.PasswordPolicyException {
        if (((BasicUser)((Object)user)).getAccountType() == BasicUser.AccountType.LOCAL) {
            this.setPassword(user, password);
            ((BasicUser)((Object)user)).setAccountExpires(LocalDateTime.now().plusMonths(12L).toInstant(ZoneOffset.UTC));
            return (T)((Object)this.deepLoad((BasicUser)((Object)this._repository.save(user))));
        }
        throw new PasswordPolicy.PasswordPolicyException("Password can be set only for LOCAL account types");
    }

    protected final void setPassword(T user, String password) throws PasswordPolicy.PasswordPolicyException {
        if (((BasicUser)((Object)user)).getAccountType() == BasicUser.AccountType.LOCAL) {
            this.assureGoodPassword(password);
            ((BasicUser)((Object)user)).setPassword(password == null ? null : this.passwordEncoder.encode((CharSequence)password));
            ((BasicUser)((Object)user)).setPasswordExpires(null);
        } else {
            ((BasicUser)((Object)user)).setPassword(THIS_IS_NOT_A_PASSWORD);
            ((BasicUser)((Object)user)).setPasswordExpires(null);
        }
    }

    public void assureGoodPassword(String password) throws PasswordPolicy.PasswordPolicyException {
        if (this.passwordPolicy != null) {
            this.passwordPolicy.assureGoodPassword(password);
        }
    }

    @Override
    @Transactional
    public void setAccountLockLocal(long userId, boolean locked) throws NoUserFoundException {
        T user = this.getUser(userId);
        if (locked) {
            ((BasicUser)((Object)user)).setLockedUntil(Instant.now().plus(this.accountLockoutTime, ChronoUnit.MILLIS));
            log.warn("Locking user account for user=" + ((BasicUser)((Object)user)).getEmail() + "  until=" + ((BasicUser)((Object)user)).getLockedUntil());
        } else {
            log.warn("Unlocking user account for user=" + ((BasicUser)((Object)user)).getEmail());
            ((BasicUser)((Object)user)).setLockedUntil(null);
        }
        this._repository.save(user);
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public void setAccountLock(long userId, boolean locked) throws NoUserFoundException {
        this.setAccountLockLocal(userId, locked);
    }

    @Override
    @Transactional
    public T setAccountType(T user, BasicUser.AccountType accountType) {
        BasicUser u = (BasicUser)((Object)this._repository.findById((Object)user.getId()).orElseThrow(() -> new EntityNotFoundException("Record not found.")));
        u.setAccountType(accountType);
        if (accountType != BasicUser.AccountType.LOCAL) {
            u.setPassword(THIS_IS_NOT_A_PASSWORD);
        }
        return (T)((Object)((BasicUser)((Object)this._repository.save((Object)u))));
    }
}

