/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.lockout;

import org.genesys.blocks.security.lockout.AccountLockoutManager;
import org.genesys.blocks.security.model.BasicUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationFailureBadCredentialsListener
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFailureBadCredentialsListener.class);
    @Autowired
    private AccountLockoutManager lockoutManager;

    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        Object principal = event.getAuthentication().getPrincipal();
        String userName = null;
        if (principal instanceof String) {
            userName = (String)principal;
        } else if (principal instanceof BasicUser) {
            userName = ((BasicUser)((Object)principal)).getUsername();
        } else if (principal instanceof UserDetails) {
            userName = ((UserDetails)principal).getUsername();
        }
        Object details = event.getAuthentication().getDetails();
        if (details instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails wad = (WebAuthenticationDetails)details;
            log.warn("Failed login attempt for username={} from IP={}", (Object)userName, (Object)wad.getRemoteAddress());
        }
        this.lockoutManager.handleFailedLogin(userName);
    }
}

