/*
 * Copyright 2023 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.oauth.model;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.Instant;

@Entity
@Table(name = "oauth_authorization")
@Data
public class Authorization {
	
	@Id
	@Column(name = "oauth_authorization_id")
	private String id;

	@Column(name = "registered_client_id", columnDefinition = "int")
	private Long registeredClientId;
	
	@Column(name = "principal_name")
	private String principalName;

	@Column(name = "authorization_grant_type")
	private String authorizationGrantType;
	
	@Column
	private String attributes;
	
	@Column(length = 50)
	private String state;

	@Column(name = "authorization_code_value")
	private String authorizationCodeValue;

	@Column(name = "authorization_code_issued_at")
	private Instant authorizationCodeIssuedAt;

	@Column(name = "authorization_code_expires_at")
	private Instant authorizationCodeExpiresAt;

	@Column(name = "authorization_code_metadata")
	private String authorizationCodeMetadata;
	
	@Column(name = "access_token_id")
	private String accessTokenId;

	@Column(name = "access_token_issued_at")
	private Instant accessTokenIssuedAt;

	@Column(name = "access_token_expires_at")
	private Instant accessTokenExpiresAt;
	
	@Column(name = "access_token_metadata")
	private String accessTokenMetadata;

	@Column(name = "access_token_type")
	private String accessTokenType;
	
	@Column(length = 100, name = "access_token_scopes")
	private String accessTokenScopes;

	@Column(name = "refresh_token_id")
	private String refreshTokenId;

	@Column(name = "refresh_token_issued_at")
	private Instant refreshTokenIssuedAt;

	@Column(name = "refresh_token_expires_at")
	private Instant refreshTokenExpiresAt;

	@Column(name = "refresh_token_metadata")
	private String refreshTokenMetadata;

	@Column(name = "oidc_id_token_id")
	private String oidcIdTokenId;

	@Column(name = "oidc_id_token_issued_at")
	private Instant oidcIdTokenIssuedAt;

	@Column(name = "oidc_id_token_expires_at")
	private Instant oidcIdTokenExpiresAt;

	@Column(name = "oidc_id_token_metadata")
	private String oidcIdTokenMetadata;

	@Column(name = "oidc_id_token_claims")
	private String oidcIdTokenClaims;
	
	@Override
	public String toString() {
		return "Authorization{" +
			"id='" + id + '\'' +
			", registeredClientId='" + registeredClientId + '\'' +
			", principalName='" + principalName + '\'' +
			", authorizationGrantType='" + authorizationGrantType + '\'' +
			", attributes='" + attributes + '\'' +
			", state='" + state + '\'' +
			", authorizationCodeValue='" + authorizationCodeValue + '\'' +
			", authorizationCodeIssuedAt=" + authorizationCodeIssuedAt +
			", authorizationCodeExpiresAt=" + authorizationCodeExpiresAt +
			", authorizationCodeMetadata='" + authorizationCodeMetadata + '\'' +
			", accessTokenId='" + accessTokenId + '\'' +
			", accessTokenIssuedAt=" + accessTokenIssuedAt +
			", accessTokenExpiresAt=" + accessTokenExpiresAt +
			", accessTokenMetadata='" + accessTokenMetadata + '\'' +
			", accessTokenType='" + accessTokenType + '\'' +
			", accessTokenScopes='" + accessTokenScopes + '\'' +
			", refreshTokenId='" + refreshTokenId + '\'' +
			", refreshTokenIssuedAt=" + refreshTokenIssuedAt +
			", refreshTokenExpiresAt=" + refreshTokenExpiresAt +
			", refreshTokenMetadata='" + refreshTokenMetadata + '\'' +
			", oidcIdTokenId='" + oidcIdTokenId + '\'' +
			", oidcIdTokenIssuedAt=" + oidcIdTokenIssuedAt +
			", oidcIdTokenExpiresAt=" + oidcIdTokenExpiresAt +
			", oidcIdTokenMetadata='" + oidcIdTokenMetadata + '\'' +
			", oidcIdTokenClaims='" + oidcIdTokenClaims + '\'' +
			'}';
	}
}
