/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.model;

import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.genesys.blocks.model.BasicModel;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;

@Entity
@Table(name="acl_entry", uniqueConstraints={@UniqueConstraint(columnNames={"acl_object_identity", "ace_order"}), @UniqueConstraint(columnNames={"acl_object_identity", "sid", "mask"})})
public class AclEntry
extends BasicModel {
    private static final long serialVersionUID = -1047000445685485825L;
    @ManyToOne(fetch=FetchType.LAZY, cascade={}, optional=false)
    @JoinColumn(name="acl_object_identity", nullable=false)
    @JsonIgnore
    private AclObjectIdentity aclObjectIdentity;
    @ManyToOne(fetch=FetchType.LAZY, cascade={}, optional=false)
    @JoinColumn(name="sid", nullable=false)
    @JsonIdentityReference(alwaysAsId=false)
    private AclSid aclSid;
    @Column(name="ace_order", nullable=false, length=11)
    private long aceOrder;
    @Column(name="mask", nullable=false)
    private int mask;
    @Column(name="granting", nullable=false, length=1)
    private boolean granting;
    @Column(name="audit_success", nullable=false, length=1)
    private boolean auditSuccess;
    @Column(name="audit_failure", nullable=false, length=1)
    private boolean auditFailure;

    public boolean canEqual(Object other) {
        return other instanceof AclEntry;
    }

    public AclObjectIdentity getAclObjectIdentity() {
        return this.aclObjectIdentity;
    }

    public AclSid getAclSid() {
        return this.aclSid;
    }

    public long getAceOrder() {
        return this.aceOrder;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isGranting() {
        return this.granting;
    }

    public boolean isAuditSuccess() {
        return this.auditSuccess;
    }

    public boolean isAuditFailure() {
        return this.auditFailure;
    }

    @JsonIgnore
    public void setAclObjectIdentity(AclObjectIdentity aclObjectIdentity) {
        this.aclObjectIdentity = aclObjectIdentity;
    }

    public void setAclSid(AclSid aclSid) {
        this.aclSid = aclSid;
    }

    public void setAceOrder(long aceOrder) {
        this.aceOrder = aceOrder;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public void setGranting(boolean granting) {
        this.granting = granting;
    }

    public void setAuditSuccess(boolean auditSuccess) {
        this.auditSuccess = auditSuccess;
    }

    public void setAuditFailure(boolean auditFailure) {
        this.auditFailure = auditFailure;
    }

    public String toString() {
        return "AclEntry(super=" + super.toString() + ", aclSid=" + this.getAclSid() + ", aceOrder=" + this.getAceOrder() + ", mask=" + this.getMask() + ", granting=" + this.isGranting() + ", auditSuccess=" + this.isAuditSuccess() + ", auditFailure=" + this.isAuditFailure() + ")";
    }
}

