/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.lockout;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.genesys.blocks.security.NoUserFoundException;
import org.genesys.blocks.security.lockout.AccountLockoutManager;
import org.genesys.blocks.security.model.BasicUser;
import org.genesys.blocks.security.service.BasicUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class LoginSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    public static final Logger LOG = LoggerFactory.getLogger(LoginSuccessHandler.class);
    private final AccountLockoutManager lockoutManager;
    private BasicUserService<?, ?> userService;

    public LoginSuccessHandler(AccountLockoutManager lockoutManager, BasicUserService<?, ?> userService) {
        this.lockoutManager = lockoutManager;
        this.userService = userService;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        super.onAuthenticationSuccess(request, response, authentication);
        Object principal = authentication.getPrincipal();
        LOG.warn("Authentication successful: {}", principal);
        if (principal instanceof BasicUser) {
            String userName = ((BasicUser)((Object)principal)).getUsername();
            this.lockoutManager.handleSuccessfulLogin(userName);
            try {
                this.userService.updateLastLogin(userName);
            }
            catch (NoUserFoundException noUserFoundException) {
                // empty catch block
            }
        }
    }
}

