/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.serialization;

import java.util.List;

import org.genesys.blocks.security.model.AclEntry;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;

/**
 * Converts a list of {@link AclEntry} to the easily digestible
 * {@link SidPermissions} objects/.
 *
 * @author Matija Obreza
 */
public class AclEntriesToPermissions implements Converter<List<AclEntry>, List<SidPermissions>> {

	/*
	 * (non-Javadoc)
	 * @see com.fasterxml.jackson.databind.util.Converter#convert(java.lang.Object)
	 */
	@Override
	public List<SidPermissions> convert(List<AclEntry> aclEntries) {
		return SidPermissions.fromEntries(aclEntries);
	}

	/*
	 * (non-Javadoc)
	 * @see
	 * com.fasterxml.jackson.databind.util.Converter#getInputType(com.fasterxml.
	 * jackson.databind.type.TypeFactory)
	 */
	@Override
	public JavaType getInputType(TypeFactory typeFactory) {
		return typeFactory.constructCollectionType(List.class, AclEntry.class);
	}

	/*
	 * (non-Javadoc)
	 * @see
	 * com.fasterxml.jackson.databind.util.Converter#getOutputType(com.fasterxml.
	 * jackson.databind.type.TypeFactory)
	 */
	@Override
	public JavaType getOutputType(TypeFactory typeFactory) {
		return typeFactory.constructCollectionType(List.class, SidPermissions.class);
	}

}
