/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.oauth.persistence;

import org.genesys.blocks.oauth.model.OAuthClient;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

/**
 * The Interface OAuthClientRepository.
 */
@Repository
public interface OAuthClientRepository extends JpaRepository<OAuthClient, Long>, QuerydslPredicateExecutor<OAuthClient> {

	/**
	 * Find by client id.
	 *
	 * @param clientId the client id
	 * @return the o auth client
	 */
	OAuthClient findByClientId(String clientId);

	/**
	 * Find by id and version.
	 *
	 * @param id the id
	 * @param version the version
	 * @return the o auth client
	 */
	OAuthClient findByIdAndVersion(long id, int version);

	/**
	 * Sets the client secret.
	 *
	 * @param id the oauth client database ID
	 * @param encodedPassword the encoded password
	 */
	@Modifying
	@Query("update OAuthClient set clientSecret = ?2 where id = ?1")
	void setClientSecret(long id, String encodedPassword);

}
