/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.model;

import java.time.Instant;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

import org.genesys.blocks.util.JsonSidConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * The Class AuditedVersionedModel.
 */
@MappedSuperclass
@Getter
@Setter
@ToString(callSuper = true)
public abstract class AuditedVersionedModel extends VersionedModel {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 427752822365309989L;

	/** The created by. */
	@JsonView(JsonViews.Protected.class)
	@CreatedBy
	@Column(updatable = false)
	@JsonSerialize(converter = JsonSidConverter.class)
	@JsonProperty(access = Access.READ_ONLY)
	private Long createdBy;

	/** The created date. */
	@JsonView(JsonViews.Public.class)
	@CreatedDate
	@Column(name = "createdDate", updatable = false)
	private Instant createdDate;

	/** The last modified by. */
	@JsonView(JsonViews.Protected.class)
	@LastModifiedBy
	@JsonSerialize(converter = JsonSidConverter.class)
	@JsonProperty(access = Access.READ_ONLY)
	private Long lastModifiedBy;

	/** The last modified date. */
	@JsonView(JsonViews.Public.class)
	@LastModifiedDate
	@Column(name = "lastModifiedDate")
	private Instant lastModifiedDate;

}
