/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.oauth.service;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.oauth.model.OAuthClient;
import org.genesys.blocks.oauth.model.OAuthRole;
import org.genesys.blocks.oauth.model.QOAuthClient;
import org.genesys.blocks.oauth.persistence.OAuthClientRepository;
import org.genesys.blocks.oauth.service.OAuthClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OAuthServiceImpl
implements OAuthClientService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthServiceImpl.class);
    private static final Set<String> SUPPORTED_GRANT_TYPES = Set.of(AuthorizationGrantType.AUTHORIZATION_CODE.getValue(), AuthorizationGrantType.CLIENT_CREDENTIALS.getValue(), AuthorizationGrantType.REFRESH_TOKEN.getValue());
    @Value(value="${base.url:#{null}}")
    private String baseUrl;
    @Value(value="${oauth.clientId.suffix:#{null}}")
    private String clientIdSuffix;
    @Autowired
    private OAuthClientRepository oauthClientRepository;
    @Autowired
    public PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    private CacheManager cacheManager;
    @Value(value="${default.oauth.accessToken.validity:259200}")
    private int ttlAccessTokenSeconds;
    @Value(value="${default.oauth.refreshToken.validity:2592000}")
    private int ttlRefreshTokenSeconds;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.clientIdSuffix)) {
            if (StringUtils.isNotEmpty((CharSequence)this.baseUrl)) {
                URL siteUrl = new URL(this.baseUrl);
                this.clientIdSuffix = siteUrl.getHost();
            } else {
                this.clientIdSuffix = "localhost";
            }
        }
    }

    @Override
    @Cacheable(cacheNames={"oauthclient"}, key="#clientId", unless="#result == null")
    public OAuthClient loadClientByClientId(String clientId) {
        OAuthClient client = this.getClient(clientId);
        if (client == null) {
            return client;
        }
        LinkedHashSet<OAuthRole> runtimeAuthorities = new LinkedHashSet<OAuthRole>(20);
        runtimeAuthorities.addAll(client.getRoles());
        runtimeAuthorities.remove((Object)OAuthRole.EVERYONE);
        runtimeAuthorities.add(OAuthRole.EVERYONE);
        client.setRuntimeAuthorities(new ArrayList<GrantedAuthority>(runtimeAuthorities));
        return client;
    }

    private OAuthClient lazyLoad(OAuthClient client) {
        if (client != null) {
            client.getRoles().size();
        }
        return client;
    }

    @Override
    public List<OAuthClient> listClientDetails() {
        return this.oauthClientRepository.findAll(Sort.by((String[])new String[]{"clientId"}));
    }

    @Override
    public Page<OAuthClient> listClientDetails(Pageable pageable) {
        return this.oauthClientRepository.findAll(pageable);
    }

    @Override
    public Page<OAuthClient> listClientDetails(Predicate predicate, Pageable pageable) {
        return this.oauthClientRepository.findAll(predicate, pageable);
    }

    @Override
    public OAuthClient getClient(String clientId) {
        OAuthClient client = this.oauthClientRepository.findByClientId(clientId);
        if (client != null) {
            client.getRoles().size();
        }
        return client;
    }

    @Override
    @Transactional
    @Caching(evict={@CacheEvict(cacheNames={"oauthclient", "oauthclient.registered"}, key="#client.clientId", condition="#client != null"), @CacheEvict(cacheNames={"oauthclient.registered.byid"}, key="#client.id", condition="#client != null and #client.id != null")})
    public OAuthClient removeClient(OAuthClient client) {
        this.oauthClientRepository.delete((Object)client);
        return client;
    }

    @Override
    @Transactional
    public OAuthClient addClient(OAuthClient client) {
        String clientId = RandomStringUtils.randomAlphanumeric((int)5).toLowerCase() + "." + RandomStringUtils.randomAlphanumeric((int)20).toLowerCase() + "@" + this.clientIdSuffix;
        String clientSecret = RandomStringUtils.randomAlphanumeric((int)32);
        OAuthClient newClient = new OAuthClient();
        newClient.apply(client);
        newClient.setClientId(clientId);
        newClient.setClientSecret(this.passwordEncoder.encode((CharSequence)clientSecret));
        newClient.getAuthorizedGrantTypes().removeIf(grant -> !SUPPORTED_GRANT_TYPES.contains(grant));
        newClient.getRoles().remove((Object)OAuthRole.EVERYONE);
        return this.lazyLoad((OAuthClient)((Object)this.oauthClientRepository.save((Object)newClient)));
    }

    @Override
    @Transactional
    @Caching(evict={@CacheEvict(cacheNames={"oauthclient", "oauthclient.registered"}, key="#updates.clientId", condition="#updates != null"), @CacheEvict(cacheNames={"oauthclient.registered.byid"}, key="#id", condition="#updates != null")})
    public OAuthClient updateClient(long id, int version, OAuthClient updates) {
        OAuthClient client = this.oauthClientRepository.findByIdAndVersion(id, version);
        client.apply(updates);
        client.getAuthorizedGrantTypes().removeIf(grant -> !SUPPORTED_GRANT_TYPES.contains(grant));
        client.getRoles().remove((Object)OAuthRole.EVERYONE);
        return this.lazyLoad((OAuthClient)((Object)this.oauthClientRepository.save((Object)client)));
    }

    @Override
    @Transactional
    @Caching(evict={@CacheEvict(cacheNames={"oauthclient", "oauthclient.registered"}, key="#sourceId", condition="#sourceId != null && #targetId != null"), @CacheEvict(cacheNames={"oauthclient.registered.byid"}, key="#result.id", condition="#result != null and #result.id != null")})
    public OAuthClient updateClientId(String sourceId, String targetId) {
        Cache sidNamesCache;
        OAuthClient client = this.getClient(sourceId);
        client.setClientId(targetId);
        if (this.cacheManager != null && (sidNamesCache = this.cacheManager.getCache("aclSidNames")) != null) {
            sidNamesCache.evict((Object)sourceId);
            sidNamesCache.evict((Object)client.getId());
        }
        return this.lazyLoad((OAuthClient)((Object)this.oauthClientRepository.save((Object)client)));
    }

    @Override
    public List<OAuthClient> autocompleteClients(String term, int limit) {
        if (StringUtils.isBlank((CharSequence)term) || term.length() < 1) {
            return Collections.emptyList();
        }
        LOG.debug("Autocomplete for={}", (Object)term);
        BooleanExpression predicate = QOAuthClient.oAuthClient.title.startsWithIgnoreCase(term).or((Predicate)QOAuthClient.oAuthClient.clientId.startsWithIgnoreCase(term)).or((Predicate)QOAuthClient.oAuthClient.description.contains(term));
        return this.oauthClientRepository.findAll((Predicate)predicate, (Pageable)PageRequest.of((int)0, (int)Math.min(100, limit), (Sort)Sort.by((String[])new String[]{"title"}))).getContent();
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#oauthClient, 'ADMINISTRATION')")
    public final String resetSecret(OAuthClient oauthClient) {
        return this.setSecret(oauthClient, null);
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#oauthClient, 'ADMINISTRATION')")
    public final String setSecret(OAuthClient oauthClient, String clientSecret) {
        assert (oauthClient != null);
        assert (oauthClient.getId() != null);
        oauthClient = (OAuthClient)((Object)this.oauthClientRepository.findById(oauthClient.getId()).orElseThrow(() -> new EntityNotFoundException("Record not found.")));
        String oldHash = oauthClient.getClientSecret();
        String newHash = null;
        do {
            if (StringUtils.isBlank((CharSequence)clientSecret)) {
                clientSecret = RandomStringUtils.randomAlphanumeric((int)32);
            }
            newHash = this.passwordEncoder.encode((CharSequence)clientSecret);
        } while (oldHash != null && oldHash.equals(newHash));
        oauthClient.setClientSecret(newHash);
        this.oauthClientRepository.save((Object)oauthClient);
        return clientSecret;
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#oauthClient, 'ADMINISTRATION')")
    public final OAuthClient removeSecret(OAuthClient oauthClient) {
        assert (oauthClient != null);
        assert (oauthClient.getId() != null);
        if ((oauthClient = (OAuthClient)((Object)this.oauthClientRepository.findById(oauthClient.getId()).orElseThrow(() -> new EntityNotFoundException("Record not found.")))).getAuthorizedGrantTypes().contains("client_credentials")) {
            throw new RuntimeException("OAuth Client with client_credentials grant must have a secret");
        }
        oauthClient.setClientSecret(null);
        oauthClient = (OAuthClient)((Object)this.oauthClientRepository.save((Object)oauthClient));
        return this.lazyLoad(oauthClient);
    }

    @Override
    public boolean isOriginRegistered(String origin) {
        AtomicBoolean found = new AtomicBoolean(false);
        this.oauthClientRepository.findAll((Predicate)QOAuthClient.oAuthClient.origins.contains(origin)).forEach(client -> {
            if (client.getAllowedOrigins().contains(origin)) {
                found.set(true);
            }
        });
        return found.get();
    }

    public void save(RegisteredClient registeredClient) {
        LOG.warn("Saving client: {}", (Object)registeredClient);
        throw new RuntimeException("Not implemented");
    }

    @Cacheable(cacheNames={"oauthclient.registered.byid"}, key="#registrationId", unless="#result == null")
    public RegisteredClient findById(String registrationId) {
        LOG.warn("Loading OAuth registered client by registrationId {}", (Object)registrationId);
        OAuthClient client = (OAuthClient)((Object)this.oauthClientRepository.findById(Long.parseLong(registrationId)).orElseThrow(() -> new EntityNotFoundException("No such client.")));
        if (client == null) {
            return null;
        }
        return this.convertToRegisteredClient(client);
    }

    @Cacheable(cacheNames={"oauthclient.registered"}, key="#clientId", unless="#result == null")
    public RegisteredClient findByClientId(String clientId) {
        LOG.warn("Loading OAuth registered client by clientId {}", (Object)clientId);
        OAuthClient client = this.loadClientByClientId(clientId);
        if (client == null) {
            return null;
        }
        return this.convertToRegisteredClient(client);
    }

    private RegisteredClient convertToRegisteredClient(OAuthClient client) {
        RegisteredClient.Builder registeredClient = RegisteredClient.withId((String)String.valueOf(client.getId()));
        registeredClient.clientId(client.getClientId()).clientSecret(client.getClientSecret()).clientIdIssuedAt(client.getCreatedDate()).clientName(client.getTitle());
        if (StringUtils.isBlank((CharSequence)client.getClientSecret())) {
            registeredClient.clientAuthenticationMethod(ClientAuthenticationMethod.NONE);
        } else {
            registeredClient.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST);
            registeredClient.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
            registeredClient.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        }
        if (CollectionUtils.isNotEmpty(client.getAuthorizedGrantTypes())) {
            client.getAuthorizedGrantTypes().stream().map(AuthorizationGrantType::new).forEach(arg_0 -> ((RegisteredClient.Builder)registeredClient).authorizationGrantType(arg_0));
        }
        if (CollectionUtils.isNotEmpty(client.getRegisteredRedirectUri())) {
            client.getRegisteredRedirectUri().forEach(arg_0 -> ((RegisteredClient.Builder)registeredClient).redirectUri(arg_0));
        }
        registeredClient.scope("openid").scope("profile").scope("email");
        if (CollectionUtils.isNotEmpty(client.getScope())) {
            client.getScope().forEach(arg_0 -> ((RegisteredClient.Builder)registeredClient).scope(arg_0));
        }
        TokenSettings.Builder token = TokenSettings.builder();
        token.accessTokenFormat(OAuth2TokenFormat.SELF_CONTAINED).accessTokenTimeToLive(Duration.of(Optional.ofNullable(client.getAccessTokenValidity()).orElse(this.ttlAccessTokenSeconds).longValue(), ChronoUnit.SECONDS)).refreshTokenTimeToLive(Duration.of(Optional.ofNullable(client.getRefreshTokenValidity()).orElse(this.ttlRefreshTokenSeconds).longValue(), ChronoUnit.SECONDS)).reuseRefreshTokens(true);
        registeredClient.tokenSettings(token.build());
        ClientSettings.Builder settings = ClientSettings.builder();
        settings.requireAuthorizationConsent(false);
        settings.setting("randomSetting", (Object)"Is here");
        if (MapUtils.isNotEmpty(client.getAdditionalInformation())) {
            client.getAdditionalInformation().entrySet().forEach(setting -> settings.setting((String)setting.getKey(), setting.getValue()));
        }
        registeredClient.clientSettings(settings.build()).build();
        return registeredClient.build();
    }
}

