/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model.filters;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.model.QUuidModel;
import org.genesys.blocks.model.filters.AuditedVersionedModelFilter;

public abstract class UuidModelFilter<T extends UuidModelFilter<T, R>, R extends AuditedVersionedModel>
extends AuditedVersionedModelFilter<T, R> {
    private static final long serialVersionUID = -2866906205548608641L;
    @JsonDeserialize(contentUsing=UUIDDeserializer.class)
    public Set<UUID> uuid;

    protected List<Predicate> collectPredicates(EntityPathBase<R> instance, QUuidModel uuidModel) {
        List<Predicate> predicates = super.collectPredicates(instance, uuidModel._super);
        if (CollectionUtils.isNotEmpty(this.uuid)) {
            predicates.add((Predicate)uuidModel.uuid.in(this.uuid));
        }
        return predicates;
    }

    public Set<UUID> uuid() {
        return this.uuid;
    }

    @JsonDeserialize(contentUsing=UUIDDeserializer.class)
    public UuidModelFilter<T, R> uuid(Set<UUID> uuid) {
        this.uuid = uuid;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UuidModelFilter)) {
            return false;
        }
        UuidModelFilter other = (UuidModelFilter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<UUID> this$uuid = this.uuid();
        Set<UUID> other$uuid = other.uuid();
        return !(this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UuidModelFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<UUID> $uuid = this.uuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        return result;
    }
}

