/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.model;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;

import org.hibernate.annotations.Type;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;

/**
 * The Class UuidEntity.
 */
@MappedSuperclass
@JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "uuid")
public abstract class UuidModel extends AuditedVersionedModel implements IdUUID {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 2639238742778129554L;

	/** The uuid. */
	@Column(unique = true, updatable = false, nullable = false)
	@Type(type = "uuid-binary")
	protected UUID uuid;

	/**
	 * {@inheritDoc}
	 */
	@PrePersist
	private void prepersistUuidModel() {
		if (this.uuid == null) {
			this.uuid = UUID.randomUUID();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.genesys.blocks.model.IdUUID#getUuid()
	 */
	@Override
	public UUID getUuid() {
		return this.uuid;
	}

	/**
	 * Sets the uuid.
	 *
	 * @param uuid the new uuid
	 */
	public void setUuid(final UUID uuid) {
		this.uuid = uuid;
	}

}
