/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.lockout;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.genesys.blocks.security.service.BasicUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.stereotype.Component;

@Component
public class AccountLockoutManager {
    private static final Logger LOG = LoggerFactory.getLogger(AccountLockoutManager.class);
    @Resource(name="accountLockoutMap")
    private Map<String, AttemptStatistics> loginAttempts;
    @Autowired
    private BasicUserService<?, ?> userService;
    private int lockAfterXFailures = 5;
    private int lockoutTime = 3600000;

    public void setLockoutTime(int lockoutTime) {
        this.lockoutTime = lockoutTime;
    }

    public void setLockAfterXFailures(int lockAfterXFailures) {
        LOG.info("Will lock user accounts after " + lockAfterXFailures + " successive failed attempts.");
        this.lockAfterXFailures = lockAfterXFailures;
    }

    public synchronized void handleSuccessfulLogin(String userName) {
        this.purge();
        if (userName == null) {
            return;
        }
        if (this.loginAttempts.containsKey(userName)) {
            AttemptStatistics stats = this.loginAttempts.get(userName);
            this.loginAttempts.remove(userName);
            LOG.info("Successful login. Removed failed login statistics for " + userName + " " + stats);
        }
    }

    public synchronized void handleFailedLogin(String userName) {
        this.purge();
        if (userName == null) {
            return;
        }
        AttemptStatistics stats = null;
        if (this.loginAttempts.containsKey(userName)) {
            stats = this.loginAttempts.get(userName);
        } else {
            try {
                Object user = this.userService.getUserByEmail(userName);
                if (user != null) {
                    stats = new AttemptStatistics();
                    stats.id = user.getId();
                    this.loginAttempts.put(userName, stats);
                }
            }
            catch (Throwable e) {
                LOG.warn("Could not load user data for {}: {}", (Object)userName, (Object)e.getMessage());
            }
        }
        if (stats != null) {
            ++stats.count;
            stats.lastAttempt = Instant.now();
            this.loginAttempts.put(userName, stats);
            LOG.info("Updated failed login statistics for username=" + userName + " " + stats);
            if (stats.count >= this.lockAfterXFailures) {
                LOG.warn("Too many failed login attempts. Locking account for username=" + userName);
                try {
                    this.userService.setAccountLockLocal(stats.id, true);
                }
                catch (Throwable e) {
                    LOG.warn("Could not lock account {}: {}", (Object)userName, (Object)e.getMessage());
                }
                throw new LockedException("Too many failed login attempts.");
            }
        }
    }

    synchronized void purge() {
        if (this.loginAttempts.size() == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Purging expired entries");
        }
        ArrayList<String> userNames = new ArrayList<String>(this.loginAttempts.keySet());
        long now = Instant.now().toEpochMilli();
        for (String userName : userNames) {
            AttemptStatistics stats = this.loginAttempts.get(userName);
            if (stats == null) {
                this.loginAttempts.remove(userName);
                continue;
            }
            if (now - stats.lastAttempt.toEpochMilli() < (long)this.lockoutTime) continue;
            this.loginAttempts.remove(userName);
            LOG.info("Removed expired failed login statistics for " + userName + " " + stats);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Number of failed login attempts in memory: " + this.loginAttempts.size());
        }
    }

    public static class AttemptStatistics
    implements Serializable {
        private static final long serialVersionUID = -5966606439944355735L;
        long id;
        int count = 0;
        Instant lastAttempt = Instant.now();

        public String toString() {
            return "count=" + this.count + " lastAttempt=" + this.lastAttempt;
        }
    }
}

