/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.serialization.Permissions;
import org.springframework.security.acls.domain.BasePermission;

public class SidPermissions
extends Permissions {
    public AclSid sid;

    public SidPermissions aclSid(AclSid aclSid) {
        this.sid = aclSid;
        return this;
    }

    public AclSid getSid() {
        return this.sid;
    }

    @Override
    public String toString() {
        return "sid=" + this.sid + " p=" + super.toString();
    }

    public static List<SidPermissions> fromEntries(List<AclEntry> aclEntries) {
        if (aclEntries == null) {
            return null;
        }
        if (aclEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SidPermissions> converted = new ArrayList<SidPermissions>(1 + aclEntries.size() / 5);
        for (AclEntry entry : aclEntries) {
            SidPermissions permission = converted.stream().filter(p -> entry.getAclSid().getId().equals(p.sid.getId())).findFirst().orElse(null);
            if (permission == null) {
                permission = new SidPermissions().aclSid(entry.getAclSid());
                converted.add(permission);
            }
            if (BasePermission.CREATE.getMask() == entry.getMask()) {
                permission.create = entry.isGranting();
                continue;
            }
            if (BasePermission.READ.getMask() == entry.getMask()) {
                permission.read = entry.isGranting();
                continue;
            }
            if (BasePermission.WRITE.getMask() == entry.getMask()) {
                permission.write = entry.isGranting();
                continue;
            }
            if (BasePermission.DELETE.getMask() == entry.getMask()) {
                permission.delete = entry.isGranting();
                continue;
            }
            if (BasePermission.ADMINISTRATION.getMask() != entry.getMask()) continue;
            permission.manage = entry.isGranting();
        }
        return converted;
    }
}

