/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.model.JsonViews;
import org.genesys.blocks.security.model.AclSid;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@MappedSuperclass
@DiscriminatorValue(value="1")
public abstract class BasicUser<R extends GrantedAuthority>
extends AclSid
implements UserDetails {
    private static final long serialVersionUID = -5318892732608111516L;
    @Column(length=36, unique=true)
    private String uuid;
    @JsonView(value={JsonViews.Public.class})
    @Column(nullable=false, unique=true, length=60)
    private String email;
    @JsonView(value={JsonViews.Public.class})
    @Column(unique=true, length=20)
    private String shortName;
    @JsonView(value={JsonViews.Public.class})
    @Column(length=60)
    private String fullName;
    @JsonIgnore
    @Column(length=60)
    private String password;
    @JsonView(value={JsonViews.Internal.class})
    private Instant accountExpires;
    @JsonView(value={JsonViews.Internal.class})
    private Instant lockedUntil;
    @JsonView(value={JsonViews.Internal.class})
    private Instant passwordExpires;
    @JsonView(value={JsonViews.Protected.class})
    @ElementCollection(fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="userrole", joinColumns={@JoinColumn(name="userId")})
    @Column(name="role")
    private Set<R> roles = new HashSet<R>();
    @JsonView(value={JsonViews.Protected.class})
    @Enumerated(value=EnumType.STRING)
    @Column(length=20)
    private AccountType accountType = AccountType.LOCAL;
    @JsonView(value={JsonViews.Internal.class})
    private Instant lastLogin;
    @Transient
    @JsonIgnore
    private List<String> runtimeAuthorities;

    public BasicUser() {
        this.setPrincipal(true);
    }

    @PrePersist
    @PreUpdate
    void ensureUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        this.setSid(this.email);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Instant getAccountExpires() {
        return this.accountExpires;
    }

    public void setAccountExpires(Instant accountExpires) {
        this.accountExpires = accountExpires;
    }

    public Instant getLockedUntil() {
        return this.lockedUntil;
    }

    public void setLockedUntil(Instant lockedUntil) {
        this.lockedUntil = lockedUntil;
    }

    public Instant getPasswordExpires() {
        return this.passwordExpires;
    }

    public void setPasswordExpires(Instant passwordExpires) {
        this.passwordExpires = passwordExpires;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<R> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<R> roles) {
        this.roles = roles;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String toString() {
        return MessageFormat.format("id={0} email={1} fullName={2}", this.getId(), this.email, this.fullName);
    }

    @Transient
    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList authorities = new ArrayList(10);
        Set<R> assignedRoles = this.getRoles();
        if (CollectionUtils.isNotEmpty(assignedRoles)) {
            authorities.addAll(assignedRoles.stream().map(role -> new SimpleGrantedAuthority(role.getAuthority())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(this.runtimeAuthorities)) {
            this.runtimeAuthorities.forEach(authority -> authorities.add(new SimpleGrantedAuthority(authority)));
        }
        return authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.email;
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isAccountNonLocked() {
        return this.lockedUntil == null || !this.lockedUntil.isAfter(Instant.now());
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isAccountLocked() {
        return !this.isAccountNonLocked();
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isCredentialsNonExpired() {
        return this.passwordExpires == null || !this.passwordExpires.isBefore(Instant.now());
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isEnabled() {
        return super.isActive();
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public Instant getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Instant lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void setRuntimeAuthorities(List<String> authorities) {
        this.runtimeAuthorities = authorities;
    }

    public static enum AccountType {
        LOCAL,
        LDAP,
        GOOGLE,
        SYSTEM,
        DELETED;

    }
}

