/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security;

import java.util.Arrays;
import java.util.List;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.model.BasicUser;
import org.genesys.blocks.util.CurrentApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class SecurityContextUtil {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityContextUtil.class);
    private static PermissionEvaluator permissionEvaluator;
    private static final Authentication ANONYMOUS_AUTH;

    private static synchronized boolean updatePermissionEvaluator() {
        permissionEvaluator = SecurityContextUtil.updateBean(PermissionEvaluator.class);
        return permissionEvaluator != null;
    }

    static final <T> T updateBean(Class<T> clazz) {
        ApplicationContext context = CurrentApplicationContext.getContext();
        if (context != null) {
            try {
                return (T)context.getBean(clazz);
            }
            catch (BeansException e) {
                LOG.warn("Could not find {} instance in your context: {}", clazz, (Object)e.getMessage());
            }
        } else {
            LOG.warn("You should initialize a bean instance of org.genesys.blocks.util.CurrentApplicationContext in your context");
        }
        return null;
    }

    public static String getUsername() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return null;
    }

    public static <T extends BasicUser<?>> T getMe() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            Object principal = auth.getPrincipal();
            if (principal instanceof BasicUser) {
                return (T)((Object)((BasicUser)((Object)principal)));
            }
            LOG.warn("Principal {} is not BasicUser, but type {}", principal, principal.getClass());
        }
        return null;
    }

    public static <T extends AclSid> T getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof AclSid) {
                return (T)((Object)((AclSid)((Object)principal)));
            }
            LOG.warn("Principal {} is not AclSid, but type {}. Auth of type {}", new Object[]{principal, principal.getClass(), authentication.getClass()});
        }
        return null;
    }

    public static boolean hasRole(String role) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            for (GrantedAuthority authority : auth.getAuthorities()) {
                if (!authority.getAuthority().equals("ROLE_" + role)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnyRole(String ... roles) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            for (GrantedAuthority authority : auth.getAuthorities()) {
                for (String role : roles) {
                    if (!authority.getAuthority().equals("ROLE_" + role)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasAuthority(String authorityName) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            for (GrantedAuthority authority : auth.getAuthorities()) {
                if (!authority.getAuthority().equals(authorityName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPermission(Object targetDomainObject, Object permission) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return SecurityContextUtil.hasPermission(auth, targetDomainObject, permission);
    }

    public static boolean hasPermission(Authentication auth, Object targetDomainObject, Object permission) {
        if (permissionEvaluator == null) {
            LOG.info("permissionEvaluator not available. Checking context again");
            if (!SecurityContextUtil.updatePermissionEvaluator()) {
                LOG.warn("permissionEvaluator not available. No permissions.");
                return false;
            }
        }
        if (auth != null) {
            return permissionEvaluator.hasPermission(auth, targetDomainObject, permission);
        }
        return false;
    }

    public static boolean anyoneHasPermission(Object targetDomainObject, Object permission) {
        if (permissionEvaluator == null) {
            LOG.info("permissionEvaluator not available. Checking context again");
            if (!SecurityContextUtil.updatePermissionEvaluator()) {
                LOG.warn("permissionEvaluator not available. No permissions.");
                return false;
            }
        }
        if (ANONYMOUS_AUTH != null) {
            return permissionEvaluator.hasPermission(ANONYMOUS_AUTH, targetDomainObject, permission);
        }
        return false;
    }

    public static String getOAuthClientId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AbstractOAuth2TokenAuthenticationToken) {
            AbstractOAuth2TokenAuthenticationToken oauthAuth = (AbstractOAuth2TokenAuthenticationToken)authentication;
            LOG.debug("OAuth authentication: {}", (Object)oauthAuth);
            Jwt token = (Jwt)oauthAuth.getToken();
            Object aud = token.getClaim("aud");
            if (aud instanceof List && !((List)aud).isEmpty()) {
                return String.valueOf(((List)aud).get(0));
            }
            return String.valueOf(aud);
        }
        LOG.warn("TODO {} {}", authentication.getClass(), (Object)authentication);
        return null;
    }

    static {
        ANONYMOUS_AUTH = new PreAuthenticatedAuthenticationToken((Object)"Anyone", null, Arrays.asList(new SimpleGrantedAuthority("ROLE_EVERYONE")));
        SecurityContextUtil.updatePermissionEvaluator();
    }
}

