/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.genesys.blocks.security.service.PasswordPolicy;
import org.springframework.stereotype.Component;

@Component
public class SimplePasswordPolicy
implements PasswordPolicy {
    private final int minLength = 8;
    private final int maxLength = Integer.MAX_VALUE;
    private final int minDigits = 1;
    private final int minSpecialChars = 1;
    private static final Pattern DIGITS = Pattern.compile("[0-9]");
    private static final Pattern SPECIAL = Pattern.compile("[^0-9a-zA-Z]");

    @Override
    public void assureGoodPassword(String password) throws PasswordPolicy.PasswordPolicyException {
        if (password == null) {
            throw new PasswordPolicy.PasswordPolicyException("Password cannot be null");
        }
        if (password.length() < 8) {
            throw new PasswordPolicy.PasswordPolicyException("Password must be at least 8 characters");
        }
        if (password.length() > Integer.MAX_VALUE) {
            throw new PasswordPolicy.PasswordPolicyException("Password must be at most 2147483647 characters");
        }
        int digitsCount = 0;
        Matcher matcher = DIGITS.matcher(password);
        while (matcher.find()) {
            ++digitsCount;
        }
        if (digitsCount < 1) {
            throw new PasswordPolicy.PasswordPolicyException("Password must have at least 1 number(s)");
        }
        int specialCount = 0;
        matcher = SPECIAL.matcher(password);
        while (matcher.find()) {
            ++specialCount;
        }
        if (specialCount < 1) {
            throw new PasswordPolicy.PasswordPolicyException("Password must have at least 1 special character(s)");
        }
    }
}

