/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import org.genesys.blocks.security.SecurityContextUtil;
import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.serialization.Permissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class CurrentPermissionsWriter
extends VirtualBeanPropertyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentPermissionsWriter.class);
    private static final long serialVersionUID = 1L;
    private static final Permissions NO_PERMISSIONS = new Permissions().grantNone();

    public CurrentPermissionsWriter() {
        LOG.trace("CurrentPermissionsWriter");
    }

    public CurrentPermissionsWriter(BeanPropertyDefinition propDef, Annotations annotations, JavaType type) {
        super(propDef, annotations, type);
        LOG.trace("CurrentPermissionsWriter");
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        if (bean == null || !(bean instanceof AclAwareModel)) {
            return null;
        }
        AclAwareModel aclAwareModel = (AclAwareModel)bean;
        if (aclAwareModel.getId() == null) {
            return null;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return NO_PERMISSIONS;
        }
        Permissions perms = new Permissions();
        try {
            perms.isPublic = SecurityContextUtil.anyoneHasPermission(aclAwareModel, "READ");
        }
        catch (Throwable e) {
            LOG.warn("Could not read public permissions {}", (Object)e.getMessage(), (Object)e);
            perms.isPublic = false;
        }
        if (SecurityContextUtil.hasRole("ADMINISTRATOR")) {
            perms.grantAll();
        } else {
            try {
                perms.create = SecurityContextUtil.hasPermission(aclAwareModel, BasePermission.CREATE);
                perms.read = SecurityContextUtil.hasPermission(aclAwareModel, BasePermission.READ);
                perms.write = SecurityContextUtil.hasPermission(aclAwareModel, BasePermission.WRITE);
                perms.delete = SecurityContextUtil.hasPermission(aclAwareModel, BasePermission.DELETE);
                perms.manage = SecurityContextUtil.hasPermission(aclAwareModel, BasePermission.ADMINISTRATION);
            }
            catch (Throwable e) {
                LOG.warn("Could not read current permissions {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return perms;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new CurrentPermissionsWriter(propDef, declaringClass.getAnnotations(), type);
    }
}

