/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.component;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.service.CustomAclService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AclAssignerAspect {
    private static final Logger LOG = LoggerFactory.getLogger(AclAssignerAspect.class);
    @Autowired
    private CustomAclService aclService;

    public AclAssignerAspect() {
        LOG.warn("Enabling {}", (Object)this.getClass().getName());
    }

    @AfterReturning(pointcut="execution(* org.springframework.data.repository.*.save(..)) || execution(* org.springframework.data.repository.*.saveAll(..)) || execution(* org.springframework.data.jpa.repository.*.save(..)) || execution(* org.springframework.data.jpa.repository.*.saveAndFlush(..))", returning="result")
    public Object afterSaveAclObject(Object result) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            if (result instanceof AclAwareModel) {
                this.maybeUpdatePermissions(result);
            } else if (result instanceof Iterable) {
                Iterable i = (Iterable)result;
                for (Object o : i) {
                    this.maybeUpdatePermissions(o);
                }
            } else {
                LOG.trace("{} is not instance of AclAwareModel", result);
            }
        }
        return result;
    }

    private void maybeUpdatePermissions(Object obj) {
        if (obj instanceof AclAwareModel) {
            this.aclService.createOrUpdatePermissions((AclAwareModel)obj);
        } else {
            LOG.trace("{} is not instance of AclAwareModel", obj);
        }
    }

    @Before(value="execution(* org.springframework.data.repository.*.delete(..)) || execution(* org.springframework.data.repository.*.deleteAll(..)) || execution(* org.springframework.data.jpa.repository.*.deleteInBatch(..))")
    public void afterDeleteAclObject(JoinPoint joinPoint) {
        if (joinPoint.getArgs().length == 0) {
            return;
        }
        Object arg0 = joinPoint.getArgs()[0];
        if (!(arg0 instanceof Long)) {
            if (arg0 instanceof AclSid) {
                AclSid aclSid = (AclSid)((Object)arg0);
                this.aclService.removePermissionsFor(aclSid);
                this.maybeRemoveAclAwareModel((Object)aclSid);
            } else if (arg0 instanceof AclAwareModel) {
                AclAwareModel aclModel = (AclAwareModel)arg0;
                this.maybeRemoveAclAwareModel(aclModel);
            } else if (arg0 instanceof Iterable) {
                Iterable i = (Iterable)arg0;
                for (Object o : i) {
                    this.maybeRemoveAclAwareModel(o);
                }
            } else {
                LOG.trace("{} is not instance of AclAwareModel", arg0);
            }
        }
    }

    private void maybeRemoveAclAwareModel(Object obj) {
        if (obj instanceof AclAwareModel) {
            LOG.debug("Removing ACL entries for model={}", obj);
            this.aclService.removeAclAwareModel((AclAwareModel)obj);
        } else {
            LOG.trace("{} is not instance of AclAwareModel", obj);
        }
    }
}

