/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model.filters;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.model.QUuidModel;
import org.genesys.blocks.model.filters.AuditedVersionedModelFilter;

public abstract class UuidModelFilter<T extends UuidModelFilter<T, R>, R extends AuditedVersionedModel>
extends AuditedVersionedModelFilter<T, R> {
    @JsonDeserialize(contentUsing=UUIDDeserializer.class)
    public Set<UUID> uuid;

    protected List<Predicate> collectPredicates(EntityPathBase<R> instance, QUuidModel uuidModel) {
        List<Predicate> predicates = super.collectPredicates(instance, uuidModel._super);
        if (CollectionUtils.isNotEmpty(this.uuid)) {
            predicates.add((Predicate)uuidModel.uuid.in(this.uuid));
        }
        return predicates;
    }

    public synchronized Set<UUID> uuid() {
        if (this.uuid == null) {
            this.uuid = new HashSet<UUID>();
        }
        return this.uuid;
    }
}

