/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.model.filters;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.model.QAuditedVersionedModel;
import org.genesys.blocks.model.filters.DateFilter;
import org.genesys.blocks.model.filters.VersionedModelFilter;

public abstract class AuditedVersionedModelFilter<T extends AuditedVersionedModelFilter<T, R>, R extends AuditedVersionedModel>
extends VersionedModelFilter<T, R> {
    public Set<Long> createdBy;
    public Set<Long> lastModifiedBy;
    public DateFilter createdDate;
    public DateFilter lastModifiedDate;

    protected List<Predicate> collectPredicates(EntityPathBase<R> instance, QAuditedVersionedModel auditedVersionedModel) {
        List predicates = super.collectPredicates(instance, auditedVersionedModel._super);
        if (CollectionUtils.isNotEmpty(this.createdBy)) {
            predicates.add(auditedVersionedModel.createdBy.in(this.createdBy));
        }
        if (CollectionUtils.isNotEmpty(this.lastModifiedBy)) {
            predicates.add(auditedVersionedModel.lastModifiedBy.in(this.lastModifiedBy));
        }
        if (this.createdDate != null) {
            predicates.add(this.createdDate.buildQuery(auditedVersionedModel.createdDate));
        }
        if (this.lastModifiedDate != null) {
            predicates.add(this.lastModifiedDate.buildQuery(auditedVersionedModel.lastModifiedDate));
        }
        return predicates;
    }

    public synchronized Set<Long> createdBy() {
        if (this.createdBy == null) {
            this.createdBy = new HashSet<Long>();
        }
        return this.createdBy;
    }

    public synchronized Set<Long> lastModifiedBy() {
        if (this.lastModifiedBy == null) {
            this.lastModifiedBy = new HashSet<Long>();
        }
        return this.lastModifiedBy;
    }

    public synchronized DateFilter createdDate() {
        if (this.createdDate == null) {
            this.createdDate = new DateFilter();
        }
        return this.createdDate;
    }

    public synchronized DateFilter lastModifiedDate() {
        if (this.lastModifiedDate == null) {
            this.lastModifiedDate = new DateFilter();
        }
        return this.lastModifiedDate;
    }
}

