/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

import org.genesys.blocks.util.JsonSidConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

/**
 * The Class AuditedVersionedModelWithoutId.
 */
@MappedSuperclass
public abstract class AuditedVersionedModelWithoutId extends VersionedModelWithoutId {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -7370145391469993768L;

	/** The created by. */
	@JsonView(JsonViews.Protected.class)
	@CreatedBy
	@Column(updatable = false)
	@JsonSerialize(converter = JsonSidConverter.class)
	@JsonProperty(access = Access.READ_ONLY)
	private Long createdBy;

	/** The created date. */
	@JsonView(JsonViews.Public.class)
	@CreatedDate
	@Column(name = "createdDate", updatable = false)
	private Date createdDate;

	/** The last modified by. */
	@JsonView(JsonViews.Protected.class)
	@LastModifiedBy
	@JsonSerialize(converter = JsonSidConverter.class)
	@JsonProperty(access = Access.READ_ONLY)
	private Long lastModifiedBy;

	/** The last modified date. */
	@JsonView(JsonViews.Public.class)
	@LastModifiedDate
	@Column(name = "lastModifiedDate")
	private Date lastModifiedDate;

	/**
	 * Gets the created by.
	 *
	 * @return the created by
	 */
	public Long getCreatedBy() {
		return createdBy;
	}

	/**
	 * Sets the created by.
	 *
	 * @param createdBy the new created by
	 */
	public void setCreatedBy(final Long createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Gets the created date.
	 *
	 * @return the created date
	 */
	public Date getCreatedDate() {
		return createdDate;
	}

	/**
	 * Sets the created date.
	 *
	 * @param createdDate the new created date
	 */
	public void setCreatedDate(final Date createdDate) {
		this.createdDate = createdDate;
	}

	/**
	 * Gets the last modified by.
	 *
	 * @return the last modified by
	 */
	public Long getLastModifiedBy() {
		return lastModifiedBy;
	}

	/**
	 * Sets the last modified by.
	 *
	 * @param lastModifiedBy the new last modified by
	 */
	public void setLastModifiedBy(final Long lastModifiedBy) {
		this.lastModifiedBy = lastModifiedBy;
	}

	/**
	 * Gets the last modified date.
	 *
	 * @return the last modified date
	 */
	public Date getLastModifiedDate() {
		return lastModifiedDate;
	}

	/**
	 * Sets the last modified date.
	 *
	 * @param lastModifiedDate the new last modified date
	 */
	public void setLastModifiedDate(final Date lastModifiedDate) {
		this.lastModifiedDate = lastModifiedDate;
	}
}
