/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.serialization.AclEntriesToPermissions;
import org.genesys.blocks.security.serialization.Permissions;
import org.genesys.blocks.security.serialization.SidPermissions;
import org.genesys.blocks.util.JsonSidConverter;
import org.springframework.security.acls.model.Permission;

public interface CustomAclService
extends JsonSidConverter.SidProvider {
    public Permission[] getAvailablePermissions(String var1);

    public AclSid getSid(Long var1);

    public AclSid getAuthoritySid(String var1);

    public AclSid ensureAuthoritySid(String var1);

    public AclSid removeAuthoritySid(String var1);

    public List<AclSid> listAuthoritySids();

    public void createOrUpdatePermissions(AclAwareModel var1);

    public void createOrUpdatePermissions(AclAwareModel var1, AclSid var2);

    public AclObjectIdentity updateInheriting(long var1, boolean var3);

    public AclObjectIdentity updateParentObject(long var1, long var3);

    public AclObjectIdentity setAclParent(AclAwareModel var1, AclAwareModel var2);

    public void removeAclAwareModel(AclAwareModel var1);

    public void removePermissionsFor(AclSid var1);

    public AclObjectIdentity getObjectIdentity(long var1);

    public AclObjectIdentity getObjectIdentity(long var1, String var3);

    public AclObjectIdentity getObjectIdentity(AclAwareModel var1);

    public List<SidPermissions> getPermissions(long var1, String var3);

    public List<SidPermissions> getPermissions(AclAwareModel var1);

    public List<AclEntry> getAclEntries(AclObjectIdentity var1);

    public AclObjectIdentity setPermissions(AclAwareModel var1, AclSid var2, Permissions var3);

    public AclObjectIdentity setPermissions(AclObjectIdentity var1, AclSid var2, Permissions var3);

    public AclObjectIdentity removePermissions(AclObjectIdentity var1, AclSid var2);

    public List<AclEntry> getAclEntries(AclAwareModel var1);

    public List<AclSid> getSids(long var1, String var3);

    public List<AclSid> getSids(AclAwareModel var1);

    public AclObjectIdentity ensureObjectIdentity(long var1, String var3);

    public List<Long> listObjectIdentityIdsForSid(Class<? extends AclAwareModel> var1, AclSid var2, Permission var3);

    public void makePubliclyReadable(AclAwareModel var1, boolean var2);

    public void cleanupAcl();

    public Long getSidId(String var1);

    public String getSidName(long var1);

    public AclObjectIdentityExt loadObjectIdentityExt(AclObjectIdentity var1);

    public static class AclObjectIdentityExt {
        @JsonUnwrapped
        public AclObjectIdentity original;
        @JsonSerialize(converter=AclEntriesToPermissions.class)
        public List<AclEntry> inherited = new ArrayList<AclEntry>();

        public AclObjectIdentityExt(AclObjectIdentity source) {
            this.original = source;
        }
    }
}

