/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.component;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.genesys.blocks.oauth.model.OAuthClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuthClientOriginCheckFilter
extends OncePerRequestFilter {
    @Autowired
    @Qualifier(value="oauthService")
    private ClientDetailsService clientDetailsService;
    private LoadingCache<String, Set<String>> clientOriginsCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Set<String>>(){

        public Set<String> load(String clientId) {
            if (OAuthClientOriginCheckFilter.this.logger.isInfoEnabled()) {
                OAuthClientOriginCheckFilter.this.logger.info((Object)("Loading allowed origins for client: " + clientId));
            }
            OAuthClient clientDetails = (OAuthClient)OAuthClientOriginCheckFilter.this.clientDetailsService.loadClientByClientId(clientId);
            return clientDetails.getAllowedOrigins();
        }
    });

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication instanceof OAuth2Authentication) {
            if (!this.checkValidOrigin(request, (OAuth2Authentication)authentication)) {
                response.sendError(403, "Request origin not valid");
                return;
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication null for origin: " + request.getHeader("Origin")));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean checkValidOrigin(HttpServletRequest request, OAuth2Authentication authAuth) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)request.getRequestURI());
            for (String headerName : Collections.list(request.getHeaderNames())) {
                this.logger.trace((Object)(">> " + headerName + ": " + request.getHeader(headerName)));
            }
        }
        String reqOrigin = request.getHeader("Origin");
        String reqReferrer = request.getHeader("Referer");
        if (authAuth.getOAuth2Request() != null) {
            boolean isGet = request.getMethod().equalsIgnoreCase("get");
            String clientId = authAuth.getOAuth2Request().getClientId();
            try {
                Set allowedOrigins = (Set)this.clientOriginsCache.get((Object)clientId);
                if (!allowedOrigins.isEmpty()) {
                    if (reqOrigin == null && reqReferrer == null) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)"No origin/referrer header in request. Denying.");
                        }
                        return false;
                    }
                    for (String allowedOrigin : allowedOrigins) {
                        if (reqOrigin != null && reqOrigin.startsWith(allowedOrigin)) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Origin match: " + reqOrigin + " for " + allowedOrigin));
                            }
                            return true;
                        }
                        if (!isGet && reqOrigin != null || reqReferrer == null || !reqReferrer.startsWith(allowedOrigin)) continue;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Referrer match: " + reqReferrer + " for " + allowedOrigin));
                        }
                        return true;
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("No origin/referrer match: " + reqOrigin + " or " + reqReferrer + " in " + allowedOrigins.toString()));
                    }
                    return false;
                }
                if (reqOrigin != null || reqReferrer != null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)(clientId + " may not be used from browsers. Denying."));
                    }
                    return false;
                }
                return true;
            }
            catch (ExecutionException e) {
                this.logger.warn((Object)"Error loading client origins", (Throwable)e);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Allowing request with Origin: " + reqOrigin));
        }
        return true;
    }
}

