/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security;

import java.util.Optional;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.service.CustomAclService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.AuditorAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class SpringSecurityAuditorAware
implements AuditorAware<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(SpringSecurityAuditorAware.class);
    @Autowired
    private CustomAclService aclService;

    public Optional<Long> getCurrentAuditor() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof AclSid) {
                return Optional.of(((AclSid)((Object)principal)).getId());
            }
            if (principal instanceof String) {
                return Optional.ofNullable(this.aclService.getSidId((String)principal));
            }
            LOG.warn("Principal {} is not AclSid, but type {}. Auth of type {}", new Object[]{principal, principal.getClass(), authentication.getClass()});
        }
        LOG.info("No security principal available.");
        return Optional.empty();
    }
}

