/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.oauth.util;

import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.oauth.model.OAuthClient;
import org.genesys.blocks.oauth.persistence.OAuthClientRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class AppBlocksInitializer
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AppBlocksInitializer.class);
    @Autowired
    private OAuthClientRepository oauthClientRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    @Qualifier(value="transactionManager")
    protected PlatformTransactionManager txManager;

    public void afterPropertiesSet() throws Exception {
        TransactionTemplate tmpl = new TransactionTemplate(this.txManager);
        tmpl.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AppBlocksInitializer.this.encodePasswords();
            }
        });
    }

    void encodePasswords() {
        long count = 0L;
        for (OAuthClient oauthClient : this.oauthClientRepository.findAll()) {
            if (!StringUtils.isNotBlank((CharSequence)oauthClient.getClientSecret()) || oauthClient.getClientSecret().startsWith("$2a$")) continue;
            ++count;
            LOG.warn("Migrating plain-text client secret to bcrypt for {}", (Object)oauthClient.getClientId());
            this.oauthClientRepository.setClientSecret(oauthClient.getId(), this.passwordEncoder.encode((CharSequence)oauthClient.getClientSecret()));
        }
        if (count == 0L) {
            LOG.warn("\n\n\t** All OAuth Client secrets are encoded **\n\t   You can remove the AppBlocksInitializer.\n\n");
        }
    }
}

