/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.oauth.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.model.Copyable;
import org.genesys.blocks.model.JsonViews;
import org.genesys.blocks.oauth.model.OAuthRole;
import org.genesys.blocks.security.model.AclSid;
import org.hibernate.annotations.Type;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.ClientDetails;

@Entity
@Table(name="oauthclient")
@DiscriminatorValue(value="2")
public class OAuthClient
extends AclSid
implements ClientDetails,
Copyable<OAuthClient> {
    private static final long serialVersionUID = -4204753722663196007L;
    @JsonView(value={JsonViews.Public.class})
    @Column(unique=true, nullable=false, updatable=false, length=100)
    private String clientId;
    @JsonView(value={JsonViews.Protected.class})
    @Column(nullable=true, length=100)
    private String clientSecret;
    @JsonIgnore
    @Column(nullable=true, length=200)
    private String resource;
    @JsonView(value={JsonViews.Protected.class})
    @Transient
    private Set<String> resourceIds = new HashSet<String>();
    @Column(nullable=false)
    boolean autoApprove = false;
    @JsonIgnore
    @Column(nullable=true, length=200)
    private String autoApproveScope;
    @JsonView(value={JsonViews.Protected.class})
    @Transient
    private Set<String> autoApproveScopes = new HashSet<String>();
    @JsonIgnore
    @Column(nullable=true, length=200)
    private String scope;
    @JsonView(value={JsonViews.Protected.class})
    @Transient
    private Set<String> scopes = new HashSet<String>();
    @JsonIgnore
    @Column(nullable=true, length=200)
    private String grants;
    @JsonView(value={JsonViews.Protected.class})
    @Transient
    private Set<String> grantTypes = new HashSet<String>();
    @JsonIgnore
    @Column(nullable=true, length=200)
    private String redirect;
    @JsonView(value={JsonViews.Protected.class})
    @Transient
    private Set<String> redirectUris = new HashSet<String>();
    @JsonView(value={JsonViews.Protected.class})
    @ElementCollection(fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="oauthclientrole", joinColumns={@JoinColumn(name="clientId")})
    @Column(name="oauthclientrole")
    private Set<OAuthRole> roles = new HashSet<OAuthRole>();
    @Transient
    private Map<String, Object> additionalInformation = null;
    private Integer accessTokenValidity;
    private Integer refreshTokenValidity;
    @Column(nullable=false, length=200)
    private String title;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Transient
    @JsonView(value={JsonViews.Protected.class})
    private Set<String> allowedOrigins = new HashSet<String>();
    @JsonIgnore
    @Column(nullable=true, length=200)
    private String origins;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Column(nullable=true, length=50)
    private String privateRecaptchaKey;
    @Column(nullable=true, length=50)
    @JsonView(value={JsonViews.Protected.class})
    private String publicRecaptchaKey;

    public OAuthClient() {
        this.setPrincipal(true);
    }

    @PrePersist
    private void assignSid() {
        this.flatten();
        this.setSid(this.clientId);
    }

    @PreUpdate
    private void flatten() {
        this.resource = this.resourceIds.stream().collect(Collectors.joining(";"));
        this.scope = this.scopes.stream().collect(Collectors.joining(";"));
        this.autoApproveScope = this.autoApproveScopes.stream().collect(Collectors.joining(";"));
        this.grants = this.grantTypes.stream().collect(Collectors.joining(";"));
        this.redirect = this.redirectUris.stream().collect(Collectors.joining(";"));
        this.origins = this.allowedOrigins.stream().collect(Collectors.joining(";"));
    }

    @PostLoad
    private void inflate() {
        if (this.resource != null) {
            Arrays.stream(StringUtils.split((String)this.resource, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(r -> this.resourceIds.add((String)r));
        }
        if (this.scope != null) {
            Arrays.stream(StringUtils.split((String)this.scope, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(s -> this.scopes.add((String)s));
        }
        if (this.autoApproveScope != null) {
            Arrays.stream(StringUtils.split((String)this.autoApproveScope, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(s -> this.autoApproveScopes.add((String)s));
        }
        if (this.grants != null) {
            Arrays.stream(StringUtils.split((String)this.grants, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(g -> this.grantTypes.add((String)g));
        }
        if (this.redirect != null) {
            Arrays.stream(StringUtils.split((String)this.redirect, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(u -> this.redirectUris.add((String)u));
        }
        if (this.origins != null) {
            Arrays.stream(StringUtils.split((String)this.origins, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(u -> this.allowedOrigins.add((String)u));
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getGrants() {
        return this.grants;
    }

    public void setGrants(String grants) {
        this.grants = grants;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public Collection<OAuthRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<OAuthRole> roles) {
        this.roles = roles;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove;
    }

    public boolean getAutoApprove() {
        return this.autoApprove;
    }

    protected String getAutoApproveScope() {
        return this.autoApproveScope;
    }

    protected void setAutoApproveScope(String autoApproveScope) {
        this.autoApproveScope = autoApproveScope;
    }

    @JsonView(value={JsonViews.Protected.class})
    public Set<String> getAutoApproveScopes() {
        return this.autoApproveScopes;
    }

    public void setAutoApproveScopes(Set<String> autoApproveScopes) {
        this.autoApproveScopes = autoApproveScopes;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public boolean isSecretRequired() {
        return this.clientSecret != null;
    }

    public boolean isScoped() {
        return !this.scopes.isEmpty();
    }

    @JsonProperty(value="clientScopes")
    public Set<String> getScope() {
        return this.scopes;
    }

    @JsonProperty(value="clientScopes")
    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    @JsonView(value={JsonViews.Protected.class})
    public Set<String> getAuthorizedGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    @JsonView(value={JsonViews.Protected.class})
    public Set<String> getRegisteredRedirectUri() {
        return this.redirectUris;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    @JsonView(value={JsonViews.Protected.class})
    @JsonDeserialize(contentUsing=GrantedAuthorityDeserializer.class)
    public Collection<GrantedAuthority> getAuthorities() {
        return this.roles.stream().collect(Collectors.toList());
    }

    public Integer getAccessTokenValiditySeconds() {
        return this.accessTokenValidity;
    }

    public Integer getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public Integer getRefreshTokenValiditySeconds() {
        return this.refreshTokenValidity;
    }

    public Integer getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public boolean isAutoApprove(String scope) {
        return this.autoApprove || this.autoApproveScopes.contains(scope);
    }

    public Map<String, Object> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(Map<String, Object> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFullName() {
        return this.clientId;
    }

    public OAuthClient copy() {
        return null;
    }

    public OAuthClient apply(OAuthClient source) {
        String oldSecret = this.clientSecret;
        super.apply((Object)source);
        this.clientSecret = oldSecret;
        this.autoApproveScopes.clear();
        this.autoApproveScopes.addAll(source.autoApproveScopes);
        this.grantTypes.clear();
        this.grantTypes.addAll(source.grantTypes);
        this.redirectUris.clear();
        this.redirectUris.addAll(source.redirectUris);
        this.resourceIds.clear();
        this.resourceIds.addAll(source.resourceIds);
        this.roles.clear();
        this.roles.addAll(source.roles);
        this.scopes.clear();
        this.scopes.addAll(source.scopes);
        this.allowedOrigins.clear();
        this.allowedOrigins.addAll(source.allowedOrigins);
        return this;
    }

    public String getOrigins() {
        return this.origins;
    }

    public void setOrigins(String origins) {
        this.origins = origins;
    }

    @JsonView(value={JsonViews.Protected.class})
    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public String getPrivateRecaptchaKey() {
        return this.privateRecaptchaKey;
    }

    public void setPrivateRecaptchaKey(String privateRecaptchaKey) {
        this.privateRecaptchaKey = privateRecaptchaKey;
    }

    public String getPublicRecaptchaKey() {
        return this.publicRecaptchaKey;
    }

    public void setPublicRecaptchaKey(String publicRecaptchaKey) {
        this.publicRecaptchaKey = publicRecaptchaKey;
    }

    private static class GrantedAuthorityDeserializer
    extends JsonDeserializer<GrantedAuthority> {
        private GrantedAuthorityDeserializer() {
        }

        public GrantedAuthority deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return OAuthRole.valueOf(p.getText());
        }
    }
}

