/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.util;

import org.genesys.blocks.security.model.AclAwareModel;

/**
 * The ACL object identity for our Java classes. Mostly used to make entity
 * types READ-able to EVERYONE by default.
 *
 * @param <T> the generic type
 */
public class ClassAclOid<T extends AclAwareModel> implements AclAwareModel {

	private Class<T> clazz;

	@Override
	public Long getId() {
		return -419l; // We use -419l for ACL OID#id for classes
	}

	/**
	 * For class.
	 *
	 * @param <T> the generic type
	 * @param clazz the clazz
	 * @return the class acl
	 */
	public static <T extends AclAwareModel> ClassAclOid<T> forClass(Class<T> clazz) {
		ClassAclOid<T> classAcl = new ClassAclOid<T>();
		classAcl.clazz = clazz;
		return classAcl;
	}

	/**
	 * Gets the clazz.
	 *
	 * @return the clazz
	 */
	public Class<T> getClazz() {
		return clazz;
	}

	/**
	 * Gets the class name.
	 *
	 * @return the class name
	 */
	public String getClassName() {
		return clazz.getName();
	}
}
