/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.genesys.blocks.security.SecurityContextUtil;
import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.model.AclClass;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.persistence.AclClassPersistence;
import org.genesys.blocks.security.persistence.AclEntryPersistence;
import org.genesys.blocks.security.persistence.AclObjectIdentityPersistence;
import org.genesys.blocks.security.persistence.AclSidPersistence;
import org.genesys.blocks.security.serialization.Permissions;
import org.genesys.blocks.security.serialization.SidPermissions;
import org.genesys.blocks.security.service.CustomAclService;
import org.genesys.blocks.util.ClassAclOid;
import org.hibernate.proxy.HibernateProxyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.model.Permission;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CustomAclServiceImpl
implements CustomAclService {
    private static Permission[] basePermissions = new Permission[]{BasePermission.CREATE, BasePermission.READ, BasePermission.WRITE, BasePermission.DELETE, BasePermission.ADMINISTRATION};
    @Autowired
    private AclObjectIdentityPersistence aclObjectIdentityPersistence;
    @Autowired
    private AclClassPersistence aclClassPersistence;
    @Autowired
    private AclEntryPersistence aclEntryPersistence;
    @Autowired(required=false)
    private CacheManager cacheManager;
    @Autowired
    private AclSidPersistence aclSidPersistence;
    @Autowired
    private EntityManager entityManager;
    private static final Logger LOG = LoggerFactory.getLogger(CustomAclServiceImpl.class);

    @Override
    @Transactional(readOnly=true)
    public AclSid getSid(Long id) {
        return (AclSid)((Object)this.aclSidPersistence.findOne(id));
    }

    @Override
    @Transactional(readOnly=true)
    @Cacheable(cacheNames={"aclSidNames"}, key="#id", unless="#result == null")
    public String getSidName(long id) {
        AclSid sid = (AclSid)((Object)this.aclSidPersistence.findOne(Long.valueOf(id)));
        return sid == null ? null : sid.getSid();
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_UNCOMMITTED)
    @Cacheable(cacheNames={"aclSidNames"}, key="#sid", unless="#result == null")
    public Long getSidId(String sid) {
        return this.aclSidPersistence.getSidId(sid);
    }

    @Override
    public AclSid getAuthoritySid(String authority) {
        return this.aclSidPersistence.findBySidAndPrincipal(authority, false);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public AclSid ensureAuthoritySid(String authority) {
        return this.ensureSidForAuthority(authority);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public AclSid removeAuthoritySid(String authority) {
        AclSid authoritySid = this.aclSidPersistence.findBySidAndPrincipal(authority, false);
        if (authoritySid == null) {
            LOG.warn("ACL SID for authority {} does not exist", (Object)authority);
            return null;
        }
        this.removePermissionsFor(authoritySid);
        this.aclSidPersistence.delete((Object)authoritySid);
        return authoritySid;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void createOrUpdatePermissions(AclAwareModel target) {
        if (target == null || target.getId() <= 0L && !(target instanceof ClassAclOid)) {
            LOG.warn("No target specified for ACL permissions, bailing out!");
            return;
        }
        String className = target.getClass().getName();
        if (target instanceof ClassAclOid) {
            className = ((ClassAclOid)target).getClassName();
        }
        AclClass aclClass = this.ensureAclClass(className);
        AclObjectIdentity objectIdentity = this.aclObjectIdentityPersistence.findByObjectIdAndClassname(target.getId(), aclClass.getAclClass());
        if (objectIdentity == null) {
            objectIdentity = new AclObjectIdentity();
            Object ownerSid = SecurityContextUtil.getCurrentUser();
            if (ownerSid == null) {
                LOG.warn("No SID in security context, not assigning creator permissions");
            } else if (!ownerSid.isPersisted()) {
                LOG.warn("Owner SID not persisted, not assigning creator permissions");
            } else {
                objectIdentity.setOwnerSid((AclSid)((Object)ownerSid));
            }
            LOG.debug("Inserting owner ACL entries for owner={} class={} id={}", new Object[]{ownerSid, target.getClass().getName(), target.getId()});
            objectIdentity.setObjectIdIdentity(target.getId());
            objectIdentity.setAclClass(aclClass);
            AclObjectIdentity parentObject = target.aclParentObjectIdentity();
            if (parentObject == null && target.aclParentObject() != null) {
                parentObject = this.getObjectIdentity(target.aclParentObject());
            }
            if (parentObject != null) {
                objectIdentity.setParentObject(parentObject);
            }
            objectIdentity.setEntriesInheriting(true);
            objectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)objectIdentity));
            if (objectIdentity.getOwnerSid() != null) {
                Permissions permissions = new Permissions().grantAll();
                this.addPermissions(objectIdentity, objectIdentity.getOwnerSid(), permissions);
            }
        } else {
            AclObjectIdentity parentObject;
            LOG.debug("Updating ACL parent object for class={} id={}", (Object)target.getClass().getName(), (Object)target.getId());
            if (objectIdentity.getOwnerSid() == null) {
                Object ownerSid = SecurityContextUtil.getCurrentUser();
                if (ownerSid != null && ownerSid.isPersisted()) {
                    objectIdentity.setOwnerSid((AclSid)((Object)ownerSid));
                    Permissions permissions = new Permissions().grantAll();
                    this.addPermissions(objectIdentity, objectIdentity.getOwnerSid(), permissions);
                } else {
                    LOG.debug("Owner SID not persisted or is null.");
                }
            }
            if ((parentObject = target.aclParentObjectIdentity()) == null && target.aclParentObject() != null) {
                parentObject = this.getObjectIdentity(target.aclParentObject());
            }
            if (parentObject != null) {
                LOG.trace("Updating ACL parent to {}", (Object)parentObject);
                objectIdentity.setParentObject(parentObject);
                objectIdentity.setEntriesInheriting(true);
            } else {
                LOG.trace("Clearing ACL parent");
                objectIdentity.setParentObject(null);
            }
            objectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)objectIdentity));
        }
        this.clearAclCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public AclObjectIdentity updateInheriting(long objectIdIdentity, boolean entriesInheriting) {
        AclObjectIdentity objectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.findOne(Long.valueOf(objectIdIdentity)));
        if (objectIdentity == null) {
            LOG.warn("ACL object identity not found by id={}", (Object)objectIdIdentity);
            return null;
        }
        if (objectIdentity.isEntriesInheriting() == entriesInheriting) {
            return objectIdentity;
        }
        try {
            LOG.info("Updating inheriting status for OID={} to {}", (Object)objectIdentity, (Object)entriesInheriting);
            objectIdentity.setEntriesInheriting(entriesInheriting);
            AclObjectIdentity aclObjectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)objectIdentity));
            return aclObjectIdentity;
        }
        finally {
            this.clearAclCache();
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public AclObjectIdentity setAclParent(AclAwareModel target, AclAwareModel parent) {
        AclObjectIdentity objectIdentity = this.getObjectIdentity(target);
        AclObjectIdentity parentIdentity = parent == null ? null : this.getObjectIdentity(parent);
        return this.updateAclParentObject(objectIdentity, parentIdentity);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public AclObjectIdentity updateParentObject(long objectIdIdentity, long parentObjectId) {
        AclObjectIdentity objectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.findOne(Long.valueOf(objectIdIdentity)));
        if (objectIdentity == null) {
            LOG.warn("ACL object identity not found by id={}", (Object)objectIdIdentity);
            return null;
        }
        AclObjectIdentity parentIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.findOne(Long.valueOf(parentObjectId)));
        if (parentIdentity == null) {
            LOG.warn("ACL object identity not found by id={}", (Object)objectIdIdentity);
            return null;
        }
        return this.updateAclParentObject(objectIdentity, parentIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AclObjectIdentity updateAclParentObject(AclObjectIdentity objectIdentity, AclObjectIdentity parentObject) {
        try {
            LOG.trace("Updating ACL parent to {}", (Object)parentObject);
            objectIdentity.setParentObject(parentObject);
            objectIdentity.setEntriesInheriting(parentObject != null);
            AclObjectIdentity aclObjectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)objectIdentity));
            return aclObjectIdentity;
        }
        finally {
            this.clearAclCache();
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_UNCOMMITTED)
    public void removeAclAwareModel(AclAwareModel target) {
        AclObjectIdentity aclObjectIdentity;
        LOG.debug("Deleting ACL data for {}", (Object)target);
        if (target instanceof AclSid) {
            LOG.info("Deleting permissions for {}", (Object)target);
            this.removePermissionsFor((AclSid)((Object)target));
        }
        if ((aclObjectIdentity = this.getObjectIdentity(target)) != null) {
            LOG.debug("OID {}#{} of {}", new Object[]{aclObjectIdentity.getAclClass().getAclClass(), aclObjectIdentity.getObjectIdIdentity(), target});
            for (AclObjectIdentity child : this.aclObjectIdentityPersistence.findByParentObject(aclObjectIdentity)) {
                LOG.debug("Has child {}#{}", (Object)child.getAclClass().getAclClass(), (Object)child.getObjectIdIdentity());
            }
            LOG.info("Deleting ACL data of {}", (Object)target);
            List<AclEntry> aclEntries = this.aclEntryPersistence.findByObjectIdentity(aclObjectIdentity);
            if (aclEntries != null) {
                this.aclEntryPersistence.delete(aclEntries);
            }
            this.aclObjectIdentityPersistence.delete((Object)aclObjectIdentity);
        }
        this.clearAclCache();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void removePermissionsFor(AclSid sid) {
        int count = this.aclEntryPersistence.deleteForSid(sid);
        LOG.debug("Deleting {} permision entries granted to {}", (Object)count, (Object)sid);
        if (count > 0) {
            this.clearAclCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AclObjectIdentity addPermissions(AclObjectIdentity objectIdentity, AclSid sid, Permissions permissions) {
        if (objectIdentity == null) {
            throw new NullPointerException("AclObjectIdentity must be provided, was null.");
        }
        if (sid == null) {
            throw new NullPointerException("AclSid must be provided, was null.");
        }
        if (permissions == null) {
            throw new NullPointerException("Permissions must be provided, was null.");
        }
        try {
            ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
            long nextAceOrder = this.getAceOrder(objectIdentity.getId());
            for (Permission permission : basePermissions) {
                int mask = permission.getMask();
                AclEntry aclEntry = new AclEntry();
                aclEntry.setAclObjectIdentity(objectIdentity);
                aclEntry.setAclSid(sid);
                aclEntry.setAceOrder(nextAceOrder++);
                aclEntry.setGranting(permissions.isGranting(mask));
                aclEntry.setAuditSuccess(true);
                aclEntry.setAuditFailure(true);
                aclEntry.setMask(mask);
                aclEntries.add(aclEntry);
            }
            this.aclEntryPersistence.save(aclEntries);
            AclObjectIdentity aclObjectIdentity = this.getObjectIdentity(objectIdentity.getId());
            return aclObjectIdentity;
        }
        finally {
            this.clearAclCache();
        }
    }

    private void clearAclCache() {
        Cache aclCache;
        if (this.cacheManager != null && (aclCache = this.cacheManager.getCache("aclCache")) != null) {
            aclCache.clear();
        }
    }

    private Long getAceOrder(long aclObjectEntityId) {
        Long maxAceOrder = this.aclEntryPersistence.getMaxAceOrderForObjectEntity(aclObjectEntityId);
        return maxAceOrder != null ? maxAceOrder + 1L : 1L;
    }

    private AclClass ensureAclClass(String className) {
        AclClass aclClass = this.aclClassPersistence.findByAclClass(className);
        if (aclClass == null) {
            LOG.warn("Missing AclClass '{}'", (Object)className);
            aclClass = new AclClass();
            aclClass.setAclClass(className);
            return (AclClass)((Object)this.aclClassPersistence.save((Object)aclClass));
        }
        return aclClass;
    }

    @Override
    @Transactional(readOnly=true)
    public CustomAclService.AclObjectIdentityExt loadObjectIdentityExt(AclObjectIdentity objectIdentity) {
        if (objectIdentity != null) {
            objectIdentity = this.getObjectIdentity(objectIdentity.getId());
            CustomAclService.AclObjectIdentityExt _aclObjectIdentity = new CustomAclService.AclObjectIdentityExt(objectIdentity);
            objectIdentity.getAclEntries().forEach(entry -> entry.getAclSid().getId());
            List<AclEntry> inheritedEntries = this.inherited(objectIdentity.getParentObject(), new ArrayList<AclEntry>(), new HashSet<AclObjectIdentity>());
            _aclObjectIdentity.inherited.addAll(inheritedEntries);
            _aclObjectIdentity.inherited.forEach(entry -> entry.getAclSid().getId());
            return _aclObjectIdentity;
        }
        return null;
    }

    private List<AclEntry> inherited(AclObjectIdentity objectIdentity, List<AclEntry> aclEntries, Set<AclObjectIdentity> handled) {
        if (objectIdentity == null || handled.contains((Object)objectIdentity)) {
            return aclEntries;
        }
        objectIdentity.getAclEntries().forEach(entry -> entry.getAclSid().getId());
        aclEntries.addAll(objectIdentity.getAclEntries());
        handled.add(objectIdentity);
        if (objectIdentity.getParentObject() != null) {
            this.inherited(objectIdentity.getParentObject(), aclEntries, handled);
        }
        return aclEntries;
    }

    @Override
    @Transactional(readOnly=true)
    @PostAuthorize(value="returnObject==null or hasRole('ADMINISTRATOR') or hasPermission(#returnObject.objectIdIdentity, #returnObject.aclClass.aclClass, 'READ')")
    public AclObjectIdentity getObjectIdentity(long id) {
        return (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.findOne(Long.valueOf(id)));
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#id, #className, 'ADMINISTRATION')")
    public AclObjectIdentity getObjectIdentity(long id, String className) {
        return this.aclObjectIdentityPersistence.findByObjectIdAndClassname(id, className);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public AclObjectIdentity getObjectIdentity(AclAwareModel entity) {
        AclObjectIdentity oid;
        if (entity == null) {
            LOG.trace("getObjectIdentity: Entity is null");
            return null;
        }
        String className = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)entity).getName();
        if (entity instanceof ClassAclOid) {
            className = ((ClassAclOid)entity).getClassName();
        }
        if ((oid = this.aclObjectIdentityPersistence.findByObjectIdAndClassname(entity.getId(), className)) == null) {
            LOG.warn("ACL object identity not found for class={} id={}", (Object)className, (Object)entity.getId());
        }
        return oid;
    }

    @Override
    @Transactional(readOnly=true)
    public Permission[] getAvailablePermissions(String className) {
        return basePermissions;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#id, #className, 'ADMINISTRATION')")
    public List<SidPermissions> getPermissions(long id, String className) {
        List<AclEntry> aclEntries = this.getAclEntries(this.getObjectIdentity(id, className));
        return SidPermissions.fromEntries(aclEntries);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public List<SidPermissions> getPermissions(AclAwareModel entity) {
        return this.getPermissions(entity.getId(), entity.getClass().getName());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_UNCOMMITTED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public AclObjectIdentity setPermissions(AclAwareModel entity, AclSid sid, Permissions permissions) {
        if (entity == null) {
            throw new NullPointerException("AclAwareModel must be provided, was null.");
        }
        if (sid == null) {
            throw new NullPointerException("AclSid must be provided, was null.");
        }
        if (permissions == null) {
            throw new NullPointerException("Permissions must be provided, was null.");
        }
        AclObjectIdentity objectIdentity = this.ensureObjectIdentity(entity);
        return this.setPermissions(objectIdentity, sid, permissions);
    }

    private AclObjectIdentity ensureObjectIdentity(AclAwareModel entity) {
        String className = entity.getClass().getName();
        if (entity instanceof ClassAclOid) {
            className = ((ClassAclOid)entity).getClassName();
        }
        AclObjectIdentity objectIdentity = this.ensureObjectIdentity(entity.getId(), className);
        return objectIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_UNCOMMITTED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#objectIdentity.objectIdIdentity, #objectIdentity.aclClass.aclClass, 'ADMINISTRATION')")
    public AclObjectIdentity setPermissions(AclObjectIdentity objectIdentity, AclSid sid, Permissions permissions) {
        if (objectIdentity == null) {
            throw new NullPointerException("AclObjectIdentity must be provided, was null.");
        }
        if (sid == null) {
            throw new NullPointerException("AclSid must be provided, was null.");
        }
        if (permissions == null) {
            throw new NullPointerException("Permissions must be provided, was null.");
        }
        try {
            List<AclEntry> aclEntries = this.aclEntryPersistence.findBySidAndObjectIdentity(sid, objectIdentity);
            if (aclEntries.isEmpty()) {
                AclObjectIdentity aclObjectIdentity = this.addPermissions(objectIdentity, sid, permissions);
                return aclObjectIdentity;
            }
            for (AclEntry aclEntry : aclEntries) {
                aclEntry.setGranting(permissions.isGranting(aclEntry.getMask()));
            }
            LOG.info("Saving " + aclEntries);
            this.aclEntryPersistence.save(aclEntries);
            Object object = this.getObjectIdentity(objectIdentity.getId());
            return object;
        }
        finally {
            this.clearAclCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_UNCOMMITTED)
    public AclObjectIdentity removePermissions(AclObjectIdentity objectIdentity, AclSid sid) {
        if (objectIdentity == null) {
            throw new NullPointerException("AclObjectIdentity must be provided, was null.");
        }
        if (sid == null) {
            throw new NullPointerException("AclSid must be provided, was null.");
        }
        try {
            List<AclEntry> aclEntries = this.aclEntryPersistence.findBySidAndObjectIdentity(sid, objectIdentity);
            LOG.debug("Deleting {} AclEntries for {}", (Object)aclEntries.size(), (Object)sid);
            this.aclEntryPersistence.delete(aclEntries);
            AclObjectIdentity aclObjectIdentity = this.getObjectIdentity(objectIdentity.getId());
            return aclObjectIdentity;
        }
        finally {
            this.clearAclCache();
        }
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#objectIdentity.objectIdIdentity, #objectIdentity.aclClass.aclClass, 'ADMINISTRATION')")
    public List<AclEntry> getAclEntries(AclObjectIdentity objectIdentity) {
        return this.aclEntryPersistence.findByObjectIdentity(objectIdentity);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public List<AclEntry> getAclEntries(AclAwareModel entity) {
        return this.aclEntryPersistence.findByObjectIdentity(this.getObjectIdentity(entity));
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#id, #className, 'ADMINISTRATION')")
    public List<AclSid> getSids(long id, String className) {
        return this.aclEntryPersistence.getSids(this.getObjectIdentity(id, className));
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public List<AclSid> getSids(AclAwareModel entity) {
        return this.aclEntryPersistence.getSids(this.getObjectIdentity(entity));
    }

    private AclSid ensureSidForAuthority(String authority) {
        AclSid roleSid = this.aclSidPersistence.findBySidAndPrincipal(authority, false);
        if (roleSid == null) {
            LOG.warn("Creating AclSid for role '{}'", (Object)authority);
            roleSid = new AclSid();
            roleSid.setPrincipal(false);
            roleSid.setSid(authority);
            return (AclSid)((Object)this.aclSidPersistence.save((Object)roleSid));
        }
        return roleSid;
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclSid> listAuthoritySids() {
        return this.aclSidPersistence.listAuthoritySids();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_UNCOMMITTED)
    public AclObjectIdentity ensureObjectIdentity(long objectIdIdentity, String className) {
        AclObjectIdentity aoi = this.aclObjectIdentityPersistence.findByObjectIdAndClassname(objectIdIdentity, className);
        if (aoi == null) {
            aoi = new AclObjectIdentity();
            aoi.setObjectIdIdentity(objectIdIdentity);
            aoi.setAclClass(this.ensureAclClass(className));
            Object ownerSid = SecurityContextUtil.getCurrentUser();
            aoi.setOwnerSid((AclSid)((Object)ownerSid));
            aoi = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)aoi));
        }
        return aoi;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> listObjectIdentityIdsForSid(Class<? extends AclAwareModel> clazz, AclSid sid, Permission permission) {
        return this.aclEntryPersistence.findObjectIdentitiesForSidAndAclClassAndMask(sid, clazz.getName(), permission.getMask());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_UNCOMMITTED)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public void makePubliclyReadable(AclAwareModel entity, boolean publiclyReadable) {
        AclSid roleEveryone = this.ensureAuthoritySid("ROLE_EVERYONE");
        if (!publiclyReadable) {
            AclObjectIdentity objectIdentity = this.ensureObjectIdentity(entity);
            this.removePermissions(objectIdentity, roleEveryone);
        } else {
            Permissions readPermissions = new Permissions().grantNone();
            readPermissions.read = publiclyReadable;
            this.setPermissions(entity, roleEveryone, readPermissions);
        }
    }

    @Override
    @Transactional
    public void cleanupAcl() {
        List OIDs = this.aclObjectIdentityPersistence.findAll();
        LOG.warn("Cleaning ACL for {} OIDs", (Object)OIDs.size());
        for (AclObjectIdentity OID : OIDs) {
            try {
                Class<?> clazz = Class.forName(OID.getAclClass().getAclClass());
                Object entity = this.entityManager.find(clazz, (Object)OID.getObjectIdIdentity());
                if (entity != null) continue;
                LOG.info("{} with OID={} no longer exists, clearing ACL", (Object)clazz.getName(), (Object)OID.getObjectIdIdentity());
                List<AclEntry> aclEntries = this.aclEntryPersistence.findByObjectIdentity(OID);
                if (aclEntries != null) {
                    this.aclEntryPersistence.delete(aclEntries);
                }
                this.aclObjectIdentityPersistence.resetChildrenOfOID(OID);
                this.aclObjectIdentityPersistence.delete((Object)OID);
            }
            catch (ClassNotFoundException e) {
                LOG.info("{} for OID={} no longer exists, clearing ACL", (Object)OID.getAclClass().getAclClass(), (Object)OID.getObjectIdIdentity());
                List<AclEntry> aclEntries = this.aclEntryPersistence.findByObjectIdentity(OID);
                if (aclEntries != null) {
                    this.aclEntryPersistence.delete(aclEntries);
                }
                this.aclObjectIdentityPersistence.resetChildrenOfOID(OID);
                this.aclObjectIdentityPersistence.delete((Object)OID);
            }
        }
        LOG.warn("Done cleaning ACL for {} OIDs", (Object)OIDs.size());
        List aclClasses = this.aclClassPersistence.findAll();
        LOG.warn("Cleaning ACL for {} ACL classes", (Object)aclClasses.size());
        for (AclClass aclClass : aclClasses) {
            try {
                Class.forName(aclClass.getAclClass());
            }
            catch (ClassNotFoundException e) {
                LOG.info("{} no longer exists, clearing ACL", (Object)aclClass.getAclClass());
                this.aclClassPersistence.delete((Object)aclClass);
            }
        }
        LOG.warn("Done cleaning ACL for {} ACL classes", (Object)aclClasses.size());
    }
}

