/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.lockout;

import org.genesys.blocks.security.lockout.AccountLockoutManager;
import org.genesys.blocks.security.model.BasicUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationSuccessListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationSuccessListener.class);
    @Autowired
    private AccountLockoutManager lockoutManager;

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Object principal = event.getAuthentication().getPrincipal();
        String userName = null;
        if (principal instanceof BasicUser) {
            userName = ((BasicUser)((Object)principal)).getUsername();
        } else if (principal instanceof UserDetails) {
            userName = ((UserDetails)principal).getUsername();
        }
        LOG.warn("Successful login for username={} princ={}", (Object)userName, principal);
        Object details = event.getAuthentication().getDetails();
        if (details != null && details instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails wad = (WebAuthenticationDetails)details;
            LOG.info("Successful login attempt for username={} from IP={}", (Object)userName, (Object)wad.getRemoteAddress());
        }
        if (principal instanceof BasicUser) {
            this.lockoutManager.handleSuccessfulLogin(userName);
        }
    }
}

