/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.oauth.service;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.oauth.model.OAuthClient;
import org.genesys.blocks.oauth.model.OAuthRole;
import org.genesys.blocks.oauth.model.QOAuthClient;
import org.genesys.blocks.oauth.persistence.OAuthClientRepository;
import org.genesys.blocks.oauth.service.OAuthClientDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OAuthServiceImpl
implements OAuthClientDetailsService {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthServiceImpl.class);
    @Value(value="${host.name}")
    private String hostname;
    @Autowired
    private OAuthClientRepository oauthClientRepository;
    @Autowired
    public PasswordEncoder passwordEncoder;

    @Cacheable(cacheNames={"oauthclient"}, key="#clientId", unless="#result == null")
    public ClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        OAuthClient client = this.oauthClientRepository.findByClientId(clientId);
        if (client == null) {
            throw new NoSuchClientException(clientId);
        }
        return this.lazyLoad(client);
    }

    private OAuthClient lazyLoad(OAuthClient client) {
        if (client != null) {
            client.getRoles().size();
            client.getRoles().add(OAuthRole.EVERYONE);
        }
        return client;
    }

    @Override
    public List<OAuthClient> listClientDetails() {
        return this.oauthClientRepository.findAll(new Sort(new String[]{"clientId"}));
    }

    @Override
    public Page<OAuthClient> listClientDetails(Pageable pageable) {
        return this.oauthClientRepository.findAll(pageable);
    }

    @Override
    public OAuthClient getClient(String clientId) {
        OAuthClient client = this.oauthClientRepository.findByClientId(clientId);
        if (client != null) {
            client.getRoles().size();
        }
        return client;
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"oauthclient"}, key="#client.clientId", condition="#client != null")
    public OAuthClient removeClient(OAuthClient client) {
        this.oauthClientRepository.delete((Object)client);
        return client;
    }

    @Override
    @Transactional
    public OAuthClient addClient(OAuthClient client) {
        String clientId = RandomStringUtils.randomAlphanumeric((int)5) + "." + RandomStringUtils.randomAlphanumeric((int)20) + "@" + this.hostname;
        String clientSecret = RandomStringUtils.randomAlphanumeric((int)32);
        OAuthClient newClient = new OAuthClient();
        newClient.apply(client);
        newClient.setClientId(clientId);
        newClient.setClientSecret(this.passwordEncoder.encode((CharSequence)clientSecret));
        return this.lazyLoad((OAuthClient)((Object)this.oauthClientRepository.save((Object)newClient)));
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"oauthclient"}, key="#updates.clientId", condition="#updates != null")
    public OAuthClient updateClient(long id, int version, OAuthClient updates) {
        OAuthClient client = this.oauthClientRepository.findByIdAndVersion(id, version);
        client.apply(updates);
        return this.lazyLoad((OAuthClient)((Object)this.oauthClientRepository.save((Object)client)));
    }

    @Override
    public List<OAuthClient> autocompleteClients(String term, int limit) {
        if (StringUtils.isBlank((CharSequence)term) || term.length() < 1) {
            return Collections.emptyList();
        }
        LOG.debug("Autocomplete for={}", (Object)term);
        BooleanExpression predicate = QOAuthClient.oAuthClient.title.startsWithIgnoreCase(term).or((Predicate)QOAuthClient.oAuthClient.clientId.startsWithIgnoreCase(term)).or((Predicate)QOAuthClient.oAuthClient.description.contains(term));
        return this.oauthClientRepository.findAll((Predicate)predicate, (Pageable)new PageRequest(0, Math.min(100, limit), new Sort(new String[]{"title"}))).getContent();
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#oauthClient, 'ADMINISTRATION')")
    public final String resetSecret(OAuthClient oauthClient) {
        oauthClient = (OAuthClient)((Object)this.oauthClientRepository.findOne(oauthClient.getId()));
        String oldHash = oauthClient.getClientSecret();
        String newHash = null;
        String clientSecret = null;
        do {
            clientSecret = RandomStringUtils.randomAlphanumeric((int)32);
            newHash = this.passwordEncoder.encode((CharSequence)clientSecret);
        } while (oldHash != null && oldHash.equals(newHash));
        oauthClient.setClientSecret(newHash);
        oauthClient = (OAuthClient)((Object)this.oauthClientRepository.save((Object)oauthClient));
        return clientSecret;
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#oauthClient, 'ADMINISTRATION')")
    public final OAuthClient removeSecret(OAuthClient oauthClient) {
        if ((oauthClient = (OAuthClient)((Object)this.oauthClientRepository.findOne(oauthClient.getId()))).getAuthorizedGrantTypes().contains("client_credentials")) {
            throw new RuntimeException("OAuth Client with client_credentials grant must have a secret");
        }
        oauthClient.setClientSecret(null);
        oauthClient = (OAuthClient)((Object)this.oauthClientRepository.save((Object)oauthClient));
        return this.lazyLoad(oauthClient);
    }
}

