/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.persistence;

import java.util.List;

import org.genesys.blocks.security.model.AclObjectIdentity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.repository.query.Param;

/**
 * The Interface AclObjectIdentityPersistence.
 */
public interface AclObjectIdentityPersistence extends JpaRepository<AclObjectIdentity, Long>, QueryDslPredicateExecutor<AclObjectIdentity> {

	/**
	 * Find by object id identity and class name.
	 *
	 * @param objectIdIdentity the object identity id
	 * @param aclClass the acl class
	 * @return the acl object identity
	 */
	@Query("select aoi from AclObjectIdentity aoi where aoi.objectIdIdentity = :objectIdIdentity and aoi.aclClass.aclClass = :aclClass")
	AclObjectIdentity findByObjectIdAndClassname(@Param("objectIdIdentity") long objectIdIdentity, @Param("aclClass") String aclClass);

	/**
	 * Clear the parentObject of child OID that use this oID as parentObject.
	 *
	 * @param oID the object identifier ID
	 */
	@Modifying
	@Query("update AclObjectIdentity aoi set aoi.parentObject = null where aoi.parentObject = ?1")
	void resetChildrenOfOID(AclObjectIdentity oID);

	List<AclObjectIdentity> findByParentObject(AclObjectIdentity parentObject);
}
