/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.blocks.security.persistence;

import org.genesys.blocks.security.model.AclClass;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/**
 * The Interface AclClassPersistence.
 */
public interface AclClassPersistence extends JpaRepository<AclClass, Long> {

	/**
	 * Class names count.
	 *
	 * @param aclClass the acl class
	 * @return the number
	 */
	@Query("select count(ac) from AclClass ac where ac.aclClass = :aclClass")
	Number classNamesCount(@Param("aclClass") String aclClass);

	/**
	 * Find by acl class.
	 *
	 * @param aclClass the acl class
	 * @return the acl class
	 */
	AclClass findByAclClass(String aclClass);
}
