/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.model;

import org.genesys.blocks.model.EntityId;
import org.genesys.blocks.security.serialization.CurrentPermissionsWriter;
import org.genesys.blocks.security.serialization.Permissions;
import org.genesys.blocks.util.JsonClassNameWriter;

import com.fasterxml.jackson.databind.annotation.JsonAppend;

/**
 * Interface label for entities that require ACL security.
 */
@JsonAppend(props = { @JsonAppend.Prop(name = "_class", value = JsonClassNameWriter.class, type = String.class),
		@JsonAppend.Prop(name = "_permissions", value = CurrentPermissionsWriter.class, type = Permissions.class) })
public interface AclAwareModel extends EntityId {

	/**
	 * Objects belonging to a parent entity can override this method.
	 *
	 * @return the parent AclAwareModel (null by default)
	 */
	default AclAwareModel aclParentObject() {
		return null;
	}

	/**
	 * A custom, persisted parent AclObjectIdentity reference. Takes precedence over
	 * {@link #aclParentObject()} when configured.
	 * 
	 * This addresses the ACL inheritance for generic use cases where no business
	 * entity relationships exist.
	 * 
	 * @return a custom parent AclObjectIdentity (null by default)
	 */
	default AclObjectIdentity aclParentObjectIdentity() {
		return null;
	}
}
