/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genesys.blocks.security.SecurityContextUtil;
import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.model.AclClass;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.persistence.AclClassPersistence;
import org.genesys.blocks.security.persistence.AclEntryPersistence;
import org.genesys.blocks.security.persistence.AclObjectIdentityPersistence;
import org.genesys.blocks.security.persistence.AclSidPersistence;
import org.genesys.blocks.security.service.CustomAclService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.model.Permission;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CustomAclServiceImpl
implements CustomAclService {
    private static Permission[] basePermissions = new Permission[]{BasePermission.CREATE, BasePermission.READ, BasePermission.WRITE, BasePermission.DELETE, BasePermission.ADMINISTRATION};
    @Autowired
    private AclObjectIdentityPersistence aclObjectIdentityPersistence;
    @Autowired
    private AclClassPersistence aclClassPersistence;
    @Autowired
    private AclEntryPersistence aclEntryPersistence;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private AclSidPersistence aclSidPersistence;
    private static final Logger LOG = LoggerFactory.getLogger(CustomAclServiceImpl.class);

    @Override
    public Map<Integer, Boolean> blankPermissionsMap() {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        for (Permission p : basePermissions) {
            map.put(p.getMask(), false);
        }
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public AclSid getSid(Long id) {
        return (AclSid)((Object)this.aclSidPersistence.findOne(id));
    }

    @Override
    public AclSid getAuthoritySid(String authority) {
        return this.ensureSidForAuthority(authority);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void addCreatorPermissions(AclAwareModel target) {
        if (target == null || target.getId() <= 0L) {
            LOG.warn("No target specified for ACL permissions, bailing out!");
            return;
        }
        Object ownerSid = SecurityContextUtil.getCurrentUser();
        if (ownerSid == null) {
            LOG.warn("No SID in security context, not assigning creator permissions");
            return;
        }
        if (!ownerSid.isPersisted()) {
            LOG.warn("Owner SID not persisted, not assigning creator permissions");
            return;
        }
        LOG.debug("Inserting owner ACL entries for owner={} class={} id={}", new Object[]{ownerSid, target.getClass().getName(), target.getId()});
        AclClass aclClass = this.ensureAclClass(target.getClass().getName());
        AclObjectIdentity objectIdentity = new AclObjectIdentity();
        objectIdentity.setObjectIdIdentity(target.getId());
        objectIdentity.setAclClass(aclClass);
        objectIdentity.setOwnerSid((AclSid)((Object)ownerSid));
        objectIdentity.setParentObject(null);
        objectIdentity.setEntriesInheriting(false);
        AclObjectIdentity savedAclObjectIdentity = this.aclObjectIdentityPersistence.findByIdAndClassname(objectIdentity.getObjectIdIdentity(), objectIdentity.getAclClass().getAclClass());
        if (savedAclObjectIdentity == null) {
            savedAclObjectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)objectIdentity));
            HashMap<Integer, Boolean> permissionsMap = new HashMap<Integer, Boolean>();
            for (Permission permission : basePermissions) {
                permissionsMap.put(permission.getMask(), true);
            }
            this.addPermissions((AclSid)((Object)ownerSid), savedAclObjectIdentity, (Map<Integer, Boolean>)permissionsMap);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void removePermissions(AclAwareModel target) {
        LOG.debug("Deleting all ACL entries for {}", (Object)target);
        AclObjectIdentity savedAclObjectIdentity = this.getObjectIdentity(target);
        if (savedAclObjectIdentity != null) {
            List<AclEntry> aclEntries = this.aclEntryPersistence.findByObjectIdentity(savedAclObjectIdentity);
            if (aclEntries != null) {
                this.aclEntryPersistence.delete(aclEntries);
                this.aclObjectIdentityPersistence.delete(savedAclObjectIdentity.getId());
            }
            this.clearAclCache();
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void removePermissionsFor(AclSid sid) {
        int count = this.aclEntryPersistence.deleteForSid(sid);
        LOG.debug("Deleting {} permision entries granted to {}", (Object)count, (Object)sid);
        if (count > 0) {
            this.clearAclCache();
        }
    }

    private boolean addPermissions(AclSid sid, AclObjectIdentity objectIdentity, Map<Integer, Boolean> permissions) {
        for (Permission permission : basePermissions) {
            int mask = permission.getMask();
            AclEntry aclEntry = new AclEntry();
            aclEntry.setAclObjectIdentity(objectIdentity);
            aclEntry.setAclSid(sid);
            aclEntry.setAceOrder(this.getAceOrder(objectIdentity.getId()));
            aclEntry.setGranting(permissions.get(mask));
            aclEntry.setAuditSuccess(true);
            aclEntry.setAuditFailure(true);
            aclEntry.setMask(mask);
            this.aclEntryPersistence.save((Object)aclEntry);
        }
        this.clearAclCache();
        return true;
    }

    private void clearAclCache() {
        Cache aclCache = this.cacheManager.getCache("aclCache");
        if (aclCache != null) {
            aclCache.clear();
        }
    }

    private Long getAceOrder(long aclObjectEntityId) {
        Long maxAceOrder = this.aclEntryPersistence.getMaxAceOrderForObjectEntity(aclObjectEntityId);
        return maxAceOrder != null ? maxAceOrder + 1L : 1L;
    }

    private AclClass ensureAclClass(String className) {
        AclClass aclClass = this.aclClassPersistence.findByAclClass(className);
        if (aclClass == null) {
            LOG.warn("Missing AclClass '{}'", (Object)className);
            aclClass = new AclClass();
            aclClass.setAclClass(className);
            return (AclClass)((Object)this.aclClassPersistence.save((Object)aclClass));
        }
        return aclClass;
    }

    @Override
    @Transactional(readOnly=true)
    public AclObjectIdentity getObjectIdentity(String className, long id) {
        return this.aclObjectIdentityPersistence.findByIdAndClassname(id, className);
    }

    @Override
    @Transactional(readOnly=true)
    public AclObjectIdentity getObjectIdentity(AclAwareModel entity) {
        AclObjectIdentity oid;
        if (entity == null) {
            LOG.error("getObjectIdentity: Entity is null");
        }
        if ((oid = this.aclObjectIdentityPersistence.findByIdAndClassname(entity.getId(), entity.getClass().getName())) == null) {
            LOG.warn("ACL object identity not found for class={} id={}", (Object)entity.getClass().getName(), (Object)entity.getId());
        }
        return oid;
    }

    @Override
    @Transactional(readOnly=true)
    public Permission[] getAvailablePermissions(String className) {
        return basePermissions;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#id, #className, 'ADMINISTRATION')")
    public Map<String, Map<Integer, Boolean>> getPermissions(long id, String className) {
        HashMap<String, Map<Integer, Boolean>> perm = new HashMap<String, Map<Integer, Boolean>>();
        List<AclEntry> aclEntries = this.getAclEntries(this.getObjectIdentity(className, id));
        for (AclEntry aclEntry : aclEntries) {
            HashMap<Integer, Boolean> granted = (HashMap<Integer, Boolean>)perm.get(aclEntry.getAclSid().getSid());
            if (granted == null) {
                granted = new HashMap<Integer, Boolean>();
                perm.put(aclEntry.getAclSid().getSid(), granted);
            }
            granted.put((int)aclEntry.getMask(), aclEntry.isGranting());
        }
        return perm;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public Map<String, Map<Integer, Boolean>> getPermissions(AclAwareModel entity) {
        return this.getPermissions(entity.getId(), entity.getClass().getName());
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public void updatePermissions(AclAwareModel entity, AclSid sid, Map<Integer, Boolean> permissions) {
        AclObjectIdentity objectIdentity = this.getObjectIdentity(entity);
        this.updatePermissions(objectIdentity, sid, permissions);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#objectIdentity.objectIdIdentity, #objectIdentity.aclClass.aclClass, 'ADMINISTRATION')")
    public void updatePermissions(AclObjectIdentity objectIdentity, AclSid sid, Map<Integer, Boolean> permissions) {
        boolean oneGranting = false;
        List<AclEntry> aclEntries = this.aclEntryPersistence.findBySidAndObjectIdentity(sid, objectIdentity);
        for (AclEntry aclEntry : aclEntries) {
            aclEntry.setGranting(permissions.get((int)aclEntry.getMask()));
            oneGranting |= aclEntry.isGranting();
        }
        if (oneGranting) {
            LOG.info("Saving " + aclEntries);
            this.aclEntryPersistence.save(aclEntries);
        } else {
            LOG.info("Deleting " + aclEntries);
            this.aclEntryPersistence.delete(aclEntries);
        }
        this.clearAclCache();
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#objectIdentity.objectIdIdentity, #objectIdentity.aclClass.aclClass, 'ADMINISTRATION')")
    public List<AclEntry> getAclEntries(AclObjectIdentity objectIdentity) {
        return this.aclEntryPersistence.findByObjectIdentity(objectIdentity);
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclEntry> getAclEntries(AclAwareModel entity) {
        return this.aclEntryPersistence.findByObjectIdentity(this.getObjectIdentity(entity));
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclSid> getSids(long id, String className) {
        return this.aclEntryPersistence.getSids(this.getObjectIdentity(className, id));
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public List<AclSid> getSids(AclAwareModel entity) {
        return this.aclEntryPersistence.getSids(this.getObjectIdentity(entity));
    }

    @Override
    public boolean addPermissions(AclAwareModel entity, AclSid sid, Map<Integer, Boolean> permissions) {
        return this.addPermissions(sid, this.getObjectIdentity(entity), permissions);
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#objectIdIdentity, #className, 'ADMINISTRATION')")
    public boolean addPermissions(long objectIdIdentity, String className, AclSid sid, Map<Integer, Boolean> permissions) {
        AclObjectIdentity oid = this.ensureObjectIdentity(className, objectIdIdentity);
        return this.addPermissions(sid, oid, permissions);
    }

    private AclSid ensureSidForAuthority(String authority) {
        AclSid roleSid = this.aclSidPersistence.findBySidAndPrincipal(authority, false);
        if (roleSid == null) {
            LOG.warn("Creating AclSid for role '{}'", (Object)authority);
            roleSid = new AclSid();
            roleSid.setPrincipal(false);
            roleSid.setSid(authority);
            return (AclSid)((Object)this.aclSidPersistence.save((Object)roleSid));
        }
        return roleSid;
    }

    @Override
    @Transactional
    public AclObjectIdentity ensureObjectIdentity(String className, long objectIdIdentity) {
        AclObjectIdentity aoi = this.aclObjectIdentityPersistence.findByIdAndClassname(objectIdIdentity, className);
        if (aoi == null) {
            aoi = new AclObjectIdentity();
            aoi.setObjectIdIdentity(objectIdIdentity);
            aoi.setAclClass(this.ensureAclClass(className));
            Object ownerSid = SecurityContextUtil.getCurrentUser();
            aoi.setOwnerSid((AclSid)((Object)ownerSid));
            aoi = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)aoi));
        }
        return aoi;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> listObjectIdentityIdsForSid(Class<? extends AclAwareModel> clazz, AclSid sid, Permission permission) {
        return this.aclEntryPersistence.findObjectIdentitiesForSidAndAclClassAndMask(sid, clazz.getName(), permission.getMask());
    }
}

