/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.security.NoUserFoundException;
import org.genesys.blocks.security.NotUniqueUserException;
import org.genesys.blocks.security.UserException;
import org.genesys.blocks.security.model.BasicUser;
import org.genesys.blocks.security.persistence.AclEntryPersistence;
import org.genesys.blocks.security.service.BasicUserService;
import org.genesys.blocks.security.service.PasswordPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class BasicUserServiceImpl<R extends GrantedAuthority, T extends BasicUser<R>>
implements BasicUserService<R, T> {
    public static final Logger LOG = LoggerFactory.getLogger(BasicUserServiceImpl.class);
    private static final String THIS_IS_NOT_A_PASSWORD = "THIS-IS-NOT-A-PASSWORD";
    private long accountLockoutTime = 300000L;
    @Autowired
    private JpaRepository<T, Long> userRepository;
    @Autowired(required=false)
    protected final PasswordEncoder passwordEncoder = NoOpPasswordEncoder.getInstance();
    @Autowired(required=false)
    private PasswordPolicy passwordPolicy;
    @Autowired(required=false)
    protected AclEntryPersistence aclEntryRepository;

    public void setAccountLockoutTime(long accountLockoutTime) {
        this.accountLockoutTime = accountLockoutTime;
    }

    @Override
    public abstract R getDefaultUserRole();

    @Override
    public abstract List<R> listAvailableRoles();

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Object user = this.getUserByEmail(username);
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        return user;
    }

    @Override
    public T getUser(long id) {
        BasicUser user = (BasicUser)((Object)this.userRepository.findOne((Serializable)Long.valueOf(id)));
        return (T)((Object)this.deepLoad(user));
    }

    public T deepLoad(T user) {
        if (user != null) {
            ((BasicUser)((Object)user)).getRoles().size();
        }
        return user;
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') || principal.id == #user.id")
    public T updateUser(T user, String email, String fullName) throws NotUniqueUserException, UserException {
        if (!StringUtils.equals((CharSequence)email, (CharSequence)((BasicUser)((Object)(user = (BasicUser)((Object)this.userRepository.findOne((Serializable)user.getId()))))).getEmail()) && this.getUserByEmail(email) != null) {
            throw new NotUniqueUserException("Email address already registered");
        }
        ((BasicUser)((Object)user)).setEmail(email);
        ((BasicUser)((Object)user)).setFullName(fullName);
        return (T)((Object)this.deepLoad((BasicUser)((Object)this.userRepository.save(user))));
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public void deleteUser(T user) {
        this.userRepository.delete(user);
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public T setRoles(T user, Set<R> newRoles) {
        if (newRoles.containsAll(((BasicUser)((Object)(user = (BasicUser)((Object)this.userRepository.findOne((Serializable)user.getId()))))).getRoles()) && ((BasicUser)((Object)user)).getRoles().containsAll(newRoles)) {
            LOG.debug("Roles {} match {}. No change.", newRoles, ((BasicUser)((Object)user)).getRoles());
            return (T)user;
        }
        ((BasicUser)((Object)user)).getRoles().clear();
        ((BasicUser)((Object)user)).getRoles().addAll(newRoles);
        ((BasicUser)((Object)user)).getRoles().add(this.getDefaultUserRole());
        LOG.info("Setting roles for user {} to {}", (Object)((BasicUser)((Object)user)).getEmail(), ((BasicUser)((Object)user)).getRoles());
        return (T)((Object)this.deepLoad((BasicUser)((Object)this.userRepository.save(user))));
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR') || principal.id == #user.id")
    public T changePassword(T user, String password) throws PasswordPolicy.PasswordPolicyException {
        if (((BasicUser)((Object)user)).getAccountType() == BasicUser.AccountType.LOCAL) {
            this.setPassword(user, password);
            return (T)((Object)this.deepLoad((BasicUser)((Object)this.userRepository.save(user))));
        }
        throw new PasswordPolicy.PasswordPolicyException("Password can be set only for LOCAL account types");
    }

    protected void setPassword(T user, String password) throws PasswordPolicy.PasswordPolicyException {
        if (((BasicUser)((Object)user)).getAccountType() == BasicUser.AccountType.LOCAL) {
            this.assureGoodPassword(password);
            ((BasicUser)((Object)user)).setPassword(password == null ? null : this.passwordEncoder.encode((CharSequence)password));
        } else {
            ((BasicUser)((Object)user)).setPassword(THIS_IS_NOT_A_PASSWORD);
        }
    }

    public void assureGoodPassword(String password) throws PasswordPolicy.PasswordPolicyException {
        if (this.passwordPolicy != null) {
            this.passwordPolicy.assureGoodPassword(password);
        }
    }

    @Override
    @Transactional
    public void setAccountLockLocal(long userId, boolean locked) throws NoUserFoundException {
        T user = this.getUser(userId);
        if (locked) {
            ((BasicUser)((Object)user)).setLockedUntil(new Date(System.currentTimeMillis() + this.accountLockoutTime));
            LOG.warn("Locking user account for user=" + ((BasicUser)((Object)user)).getEmail() + "  until=" + ((BasicUser)((Object)user)).getLockedUntil());
        } else {
            LOG.warn("Unlocking user account for user=" + ((BasicUser)((Object)user)).getEmail());
            ((BasicUser)((Object)user)).setLockedUntil(null);
        }
        this.userRepository.save(user);
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public void setAccountLock(long userId, boolean locked) throws NoUserFoundException {
        this.setAccountLockLocal(userId, locked);
    }

    @Override
    @Transactional
    public T setAccountType(T user, BasicUser.AccountType accountType) {
        BasicUser u = (BasicUser)((Object)this.userRepository.findOne((Serializable)user.getId()));
        u.setAccountType(accountType);
        if (accountType != BasicUser.AccountType.LOCAL) {
            ((BasicUser)((Object)user)).setPassword(THIS_IS_NOT_A_PASSWORD);
        }
        return (T)((Object)((BasicUser)((Object)this.userRepository.save((Object)u))));
    }
}

