/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import org.genesys.blocks.security.serialization.CurrentPermissions;
import org.genesys.blocks.util.CurrentApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class CurrentPermissionsWriter
extends VirtualBeanPropertyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentPermissionsWriter.class);
    private static final long serialVersionUID = 1L;
    private static PermissionEvaluator permissionEvaluator;

    public CurrentPermissionsWriter() {
        LOG.trace("CurrentPermissionsWriter");
    }

    public CurrentPermissionsWriter(BeanPropertyDefinition propDef, Annotations annotations, JavaType type) {
        super(propDef, annotations, type);
        LOG.trace("CurrentPermissionsWriter");
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Authentication authentication;
        if (permissionEvaluator != null && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null) {
            CurrentPermissions perms = new CurrentPermissions();
            perms.create = permissionEvaluator.hasPermission(authentication, bean, (Object)BasePermission.CREATE);
            perms.read = permissionEvaluator.hasPermission(authentication, bean, (Object)BasePermission.READ);
            perms.write = permissionEvaluator.hasPermission(authentication, bean, (Object)BasePermission.WRITE);
            perms.delete = permissionEvaluator.hasPermission(authentication, bean, (Object)BasePermission.DELETE);
            perms.manage = permissionEvaluator.hasPermission(authentication, bean, (Object)BasePermission.ADMINISTRATION);
            return perms;
        }
        return null;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new CurrentPermissionsWriter(propDef, declaringClass.getAnnotations(), type);
    }

    static {
        ApplicationContext context = CurrentApplicationContext.getContext();
        if (context != null) {
            try {
                permissionEvaluator = (PermissionEvaluator)context.getBean(PermissionEvaluator.class);
            }
            catch (BeansException e) {
                LOG.warn("Could not find PermissionEvaluator instance in your context");
            }
        } else {
            LOG.warn("You should initialize a bean instance of org.genesys.blocks.util.CurrentApplicationContext in your context");
        }
    }
}

