/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.persistence;

import java.util.List;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface AclEntryPersistence
extends JpaRepository<AclEntry, Long> {
    @Query(value="select ae from AclEntry ae where ae.aclObjectIdentity = :aclObjectIdentity")
    public List<AclEntry> findByObjectIdentity(@Param(value="aclObjectIdentity") AclObjectIdentity var1);

    @Query(value="select ae from AclEntry ae where ae.aclSid = :aclSid and ae.aclObjectIdentity = :aclObjectIdentity")
    public List<AclEntry> findBySidAndObjectIdentity(@Param(value="aclSid") AclSid var1, @Param(value="aclObjectIdentity") AclObjectIdentity var2);

    @Query(value="select ae.aclObjectIdentity.objectIdIdentity from AclEntry ae where ae.aclSid=?1 and ae.aclObjectIdentity.aclClass.aclClass=?2 and ae.mask=?3 and ae.granting=true")
    public List<Long> findObjectIdentitiesForSidAndAclClassAndMask(AclSid var1, String var2, long var3);

    @Query(value="select max(ae.aceOrder) from AclEntry ae join ae.aclObjectIdentity aoi where aoi.id = ?1")
    public Long getMaxAceOrderForObjectEntity(long var1);

    @Query(value="select distinct ae.aclSid from AclEntry ae where ae.aclObjectIdentity = :objectIdentity")
    public List<AclSid> getSids(@Param(value="objectIdentity") AclObjectIdentity var1);

    @Modifying
    @Query(value="delete from AclEntry ae where ae.aclSid = :sid")
    public <T extends AclSid> int deleteForSid(@Param(value="sid") T var1);
}

