/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.lockout;

import org.genesys.blocks.security.lockout.AccountLockoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationFailureBadCredentialsListener
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFailureBadCredentialsListener.class);
    @Autowired
    private AccountLockoutManager lockoutManager;

    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        String userName = (String)event.getAuthentication().getPrincipal();
        Object details = event.getAuthentication().getDetails();
        if (details != null && details instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails wad = (WebAuthenticationDetails)details;
            LOG.warn("Failed login attempt for username={} from IP={}", (Object)userName, (Object)wad.getRemoteAddress());
        }
        this.lockoutManager.handleFailedLogin(userName);
    }
}

