/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security;

import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.model.BasicUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityContextUtil {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityContextUtil.class);

    public static String getUsername() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return null;
    }

    public static <T extends BasicUser<?>> T getMe() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            Object principal = auth.getPrincipal();
            if (principal instanceof BasicUser) {
                return (T)((Object)((BasicUser)((Object)principal)));
            }
            LOG.warn("Principal {} is not BasicUser, but type {}", principal, principal.getClass());
        }
        return null;
    }

    public static <T extends AclSid> T getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof AclSid) {
                return (T)((Object)((AclSid)((Object)principal)));
            }
            LOG.warn("Principal {} is not AclSid, but type {}", principal, principal.getClass());
        }
        return null;
    }
}

