/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.genesys.blocks.model.BasicModel;

/**
 * ACL Entry represents permissions of {@link AclSid} on a particular entity
 * (through {@link AclObjectIdentity}).
 */
@Entity
@Table(name = "acl_entry", uniqueConstraints = @UniqueConstraint(columnNames = { "acl_object_identity", "ace_order" }))
public class AclEntry extends BasicModel {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -1047000445685485825L;

	/** The acl object identity. */
	@ManyToOne(fetch = FetchType.LAZY, cascade = {}, optional = false)
	@JoinColumn(name = "acl_object_identity", nullable = false)
	private AclObjectIdentity aclObjectIdentity;

	/** The acl sid. */
	@ManyToOne(fetch = FetchType.LAZY, cascade = {}, optional = false)
	@JoinColumn(name = "sid", nullable = false)
	private AclSid aclSid;

	/** The ace order. */
	@Column(name = "ace_order", nullable = false, length = 11)
	private long aceOrder;

	/** The mask. */
	@Column(name = "mask", nullable = false, length = 11)
	private long mask;

	/** The granting. */
	@Column(name = "granting", nullable = false, length = 1)
	private boolean granting;

	/** The audit success. */
	@Column(name = "audit_success", nullable = false, length = 1)
	private boolean auditSuccess;

	/** The audit failure. */
	@Column(name = "audit_failure", nullable = false, length = 1)
	private boolean auditFailure;

	/**
	 * Gets the acl object identity.
	 *
	 * @return the acl object identity
	 */
	public AclObjectIdentity getAclObjectIdentity() {
		return aclObjectIdentity;
	}

	/**
	 * Sets the acl object identity.
	 *
	 * @param aclObjectIdentity the new acl object identity
	 */
	public void setAclObjectIdentity(final AclObjectIdentity aclObjectIdentity) {
		this.aclObjectIdentity = aclObjectIdentity;
	}

	/**
	 * Gets the acl sid.
	 *
	 * @return the acl sid
	 */
	public AclSid getAclSid() {
		return aclSid;
	}

	/**
	 * Sets the acl sid.
	 *
	 * @param aclSid the new acl sid
	 */
	public void setAclSid(final AclSid aclSid) {
		this.aclSid = aclSid;
	}

	/**
	 * Gets the ace order.
	 *
	 * @return the ace order
	 */
	public long getAceOrder() {
		return aceOrder;
	}

	/**
	 * Sets the ace order.
	 *
	 * @param aceOrder the new ace order
	 */
	public void setAceOrder(final long aceOrder) {
		this.aceOrder = aceOrder;
	}

	/**
	 * Gets the mask.
	 *
	 * @return the mask
	 */
	public long getMask() {
		return mask;
	}

	/**
	 * Sets the mask.
	 *
	 * @param mask the new mask
	 */
	public void setMask(final long mask) {
		this.mask = mask;
	}

	/**
	 * Checks if is granting.
	 *
	 * @return true, if is granting
	 */
	public boolean isGranting() {
		return granting;
	}

	/**
	 * Sets the granting.
	 *
	 * @param granting the new granting
	 */
	public void setGranting(final boolean granting) {
		this.granting = granting;
	}

	/**
	 * Checks if is audit success.
	 *
	 * @return true, if is audit success
	 */
	public boolean isAuditSuccess() {
		return auditSuccess;
	}

	/**
	 * Sets the audit success.
	 *
	 * @param auditSuccess the new audit success
	 */
	public void setAuditSuccess(final boolean auditSuccess) {
		this.auditSuccess = auditSuccess;
	}

	/**
	 * Checks if is audit failure.
	 *
	 * @return true, if is audit failure
	 */
	public boolean isAuditFailure() {
		return auditFailure;
	}

	/**
	 * Sets the audit failure.
	 *
	 * @param auditFailure the new audit failure
	 */
	public void setAuditFailure(final boolean auditFailure) {
		this.auditFailure = auditFailure;
	}
}
