/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.blocks.security;

/**
 * The Class NoUserFoundException.
 */
public class NoUserFoundException extends UserException {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -3218537334751840421L;

	/**
	 * Instantiates a new no user found exception.
	 */
	public NoUserFoundException() {
	}

	/**
	 * Instantiates a new no user found exception.
	 *
	 * @param message the message
	 */
	public NoUserFoundException(final String message) {
		super(message);
	}

	/**
	 * Instantiates a new no user found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public NoUserFoundException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * Instantiates a new no user found exception.
	 *
	 * @param cause the cause
	 */
	public NoUserFoundException(final Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new no user found exception.
	 *
	 * @param modelId the model id
	 */
	public NoUserFoundException(final long modelId) {
		this.modelId = modelId;
	}

	/**
	 * Instantiates a new no user found exception.
	 *
	 * @param cause the cause
	 * @param modelId the model id
	 */
	public NoUserFoundException(final Throwable cause, final long modelId) {
		super(cause);
		this.modelId = modelId;
	}

	/** The model id. */
	private long modelId;

	/**
	 * Gets the model id.
	 *
	 * @return the model id
	 */
	public long getModelId() {
		return modelId;
	}

}
