/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.oauth.service;

import java.util.List;

import org.genesys.blocks.oauth.model.AccessToken;
import org.genesys.blocks.oauth.model.RefreshToken;
import org.springframework.security.oauth2.provider.token.TokenStore;

/**
 * The Interface OAuthTokenStoreService.
 */
public interface OAuthTokenStoreService extends TokenStore {

	/**
	 * Find access tokens by client id.
	 *
	 * @param clientId the client id
	 * @return the list
	 */
	List<AccessToken> findAccessTokensByClientId(String clientId);

	/**
	 * Removes the access token.
	 *
	 * @param tokenId the token id
	 */
	void removeAccessToken(String tokenId);

	/**
	 * Find tokens by user uuid.
	 *
	 * @param uuid the uuid
	 * @return the list
	 */
	List<AccessToken> findTokensByUserUuid(String uuid);

	/**
	 * Find refresh tokens by client id.
	 *
	 * @param clientId the client id
	 * @return the list
	 */
	List<RefreshToken> findRefreshTokensByClientId(String clientId);

	/**
	 * Removes the refresh token.
	 *
	 * @param tokenId the token id
	 */
	void removeRefreshToken(String tokenId);

}
